/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.core.CleanUpHandler;
import adams.core.logging.LoggingObject;
import adams.data.container.DataContainer;
import adams.data.statistics.InformativeStatistic;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractDataStatistic<T extends DataContainer>
extends LoggingObject
implements InformativeStatistic,
CleanUpHandler {
    private static final long serialVersionUID = 7783784686641582858L;
    protected Hashtable<String, Double> m_Statistics = new Hashtable();
    protected List<String> m_Names = new ArrayList<String>();
    protected boolean m_Calculated = false;
    protected T m_Data = null;

    public AbstractDataStatistic() {
    }

    public AbstractDataStatistic(T data) {
        this();
        this.setData(data);
    }

    public abstract String globalInfo();

    @Override
    public void cleanUp() {
        this.clear();
    }

    protected void clear() {
        this.m_Calculated = false;
        this.m_Statistics.clear();
        this.m_Names.clear();
    }

    protected void calculate() {
        this.clear();
    }

    public void setData(T value) {
        this.m_Calculated = false;
        this.m_Data = value;
    }

    public T getData() {
        return this.m_Data;
    }

    public void add(String name, double value) {
        if (!this.m_Statistics.containsKey(name)) {
            this.m_Names.add(name);
        }
        this.m_Statistics.put(name, value);
    }

    protected double numberToDouble(Number value) {
        if (value == null) {
            return Double.NaN;
        }
        return value.doubleValue();
    }

    @Override
    public Iterator<String> statisticNames() {
        if (!this.m_Calculated) {
            this.calculate();
        }
        return new ArrayList<String>(this.m_Names).iterator();
    }

    @Override
    public double getStatistic(String name) {
        double result;
        if (!this.m_Calculated) {
            this.calculate();
        }
        if (this.m_Statistics.containsKey(name)) {
            result = this.m_Statistics.get(name);
        } else {
            this.getLogger().severe("Statistic '" + name + "' is unknown!");
            result = Double.NaN;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        Iterator<String> names = this.statisticNames();
        while (names.hasNext()) {
            String name = names.next();
            result.append(name + ": " + this.getStatistic(name) + "\n");
        }
        return result.toString();
    }
}

