/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.db.SQL;
import adams.flow.condition.bool.AbstractBooleanDatabaseCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.ArrayList;
import java.util.logging.Level;

public class TableExists
extends AbstractBooleanDatabaseCondition {
    private static final long serialVersionUID = -338472091205326476L;
    protected BaseRegExp m_RegExp;

    @Override
    public String globalInfo() {
        return "Checks whether table(s) exist that match the given regular expression.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression used for matching the table names.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "regExp", this.m_RegExp);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected boolean doEvaluate(Actor owner, Token token) {
        result = false;
        conn = this.getDatabaseConnection().getConnection(false);
        if (conn == null) {
            this.getLogger().severe("Failed to obtain database connection??");
            return result;
        }
        try {
            metadata = conn.getMetaData();
            rs = null;
            tables = new ArrayList<String>();
            try {
                rs = metadata.getTables(null, null, null, new String[]{"TABLE"});
                while (rs.next()) {
                    tables.add(rs.getString("TABLE_NAME"));
                }
                ** if (rs == null) goto lbl-1000
            }
            catch (Exception e) {
                try {
                    this.getLogger().log(Level.SEVERE, "Failed to retrieve list of tables:", e);
                    ** if (rs == null) goto lbl-1000
                }
                catch (Throwable var9_11) {
                    if (rs != null) {
                        SQL.closeAll(rs);
                    }
                    throw var9_11;
                }
lbl-1000:
                // 1 sources

                {
                    SQL.closeAll(rs);
                }
lbl-1000:
                // 2 sources

                {
                }
            }
lbl-1000:
            // 1 sources

            {
                SQL.closeAll(rs);
            }
lbl-1000:
            // 2 sources

            {
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Tables found: " + tables);
            }
            for (String table : tables) {
                if (!this.m_RegExp.isMatch(table)) continue;
                result = true;
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Table matches '" + this.m_RegExp + "': " + table);
                }
                break;
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to check for tables:", e);
        }
        return result;
    }
}

