/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.test;

import adams.core.ClassLister;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.flow.condition.test.TestCondition;

public abstract class AbstractTestCondition
extends AbstractOptionHandler
implements Comparable,
TestCondition {
    private static final long serialVersionUID = 3879444121041551968L;
    protected boolean m_Tested;
    protected String m_TestResult;

    @Override
    protected void initialize() {
        this.m_TestResult = null;
    }

    @Override
    public void reset() {
        this.m_Tested = false;
        this.m_TestResult = null;
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    protected abstract String performTest();

    @Override
    public String getTestResult() {
        if (!this.m_Tested) {
            this.m_TestResult = this.performTest();
            this.m_Tested = true;
        }
        return this.m_TestResult;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public TestCondition shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public TestCondition shallowCopy(boolean expand) {
        return (TestCondition)((Object)OptionUtils.shallowCopy(this, expand));
    }

    public static String[] getConditions() {
        return ClassLister.getSingleton().getClassnames(TestCondition.class);
    }

    public static TestCondition forName(String classname, String[] options) {
        TestCondition result;
        try {
            result = (TestCondition)OptionUtils.forName(TestCondition.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static TestCondition forCommandLine(String cmdline) {
        return (TestCondition)((Object)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline));
    }
}

