/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.Variables;
import adams.core.option.OptionHandler;
import adams.flow.sink.Display;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.UpdateableDisplayPanel;
import adams.flow.transformer.AbstractInteractiveTransformerDialog;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class Inspect
extends AbstractInteractiveTransformerDialog {
    private static final long serialVersionUID = 950028795723993391L;
    public static final String TEXT_INTERACTIVE = "Interactive";
    public static final String TEXT_NONINTERACTIVE = "Non-interactive";
    protected DisplayPanelProvider m_PanelProvider;
    protected String m_LabelSkip;
    protected String m_LabelAccept;
    protected JButton m_ButtonToggle;
    protected JButton m_ButtonSkip;
    protected JButton m_ButtonAccept;
    protected boolean m_Interactive;
    protected boolean m_Accepted;
    protected Boolean m_Waiting;

    @Override
    public String globalInfo() {
        return "Allows the user to inspect tokens with the specified viewer.\nInspection can be done interactively, allowing the user to drop tokens, or non-interactively, with the viewer updating whenever a token passes through.\nOf course, this actor should only be used during development for debugging purposes as can slow down the execution significantly depending on how expensive the view generation is.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("provider", "panelProvider", new Display());
        this.m_OptionManager.add("label-skip", "labelSkip", "_Skip");
        this.m_OptionManager.add("label-accept", "labelAccept", "_Accept");
    }

    public void setPanelProvider(DisplayPanelProvider value) {
        this.m_PanelProvider = value;
        this.reset();
    }

    public DisplayPanelProvider getPanelProvider() {
        return this.m_PanelProvider;
    }

    public String panelProviderTipText() {
        return "The actor for generating the viewer.";
    }

    public void setLabelSkip(String value) {
        this.m_LabelSkip = value;
        this.reset();
    }

    public String getLabelSkip() {
        return this.m_LabelSkip;
    }

    public String labelSkipTipText() {
        return "The label to use for the skip button; let '_' precede the character that should trigger the button via 'Alt+<char>' (Windows/Linux).";
    }

    public void setLabelAccept(String value) {
        this.m_LabelAccept = value;
        this.reset();
    }

    public String getLabelAccept() {
        return this.m_LabelAccept;
    }

    public String labelAcceptTipText() {
        return "The label to use for the accept button; let '_' precede the character that should trigger the button via 'Alt+<char>' (Windows/Linux).";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "panelProvider", this.m_PanelProvider, ", provider: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "labelSkip", this.m_LabelSkip, ", skip: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "labelAccept", this.m_LabelAccept, ", accept: ");
        return result;
    }

    @Override
    public Class[] accepts() {
        return this.m_PanelProvider.accepts();
    }

    @Override
    public Class[] generates() {
        return this.m_PanelProvider.accepts();
    }

    @Override
    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        this.m_PanelProvider.setVariables(value);
    }

    @Override
    public void clearPanel() {
        if (this.m_Panel != null) {
            ((DisplayPanel)((Object)this.m_Panel)).clearPanel();
        }
    }

    @Override
    protected BasePanel newPanel() {
        return (BasePanel)((Object)this.m_PanelProvider.createDisplayPanel(null));
    }

    @Override
    protected BaseDialog doCreateDialog(BasePanel panel) {
        BaseDialog result = super.doCreateDialog(panel);
        result.setModalityType(Dialog.ModalityType.MODELESS);
        JPanel panelButtons = new JPanel(new BorderLayout());
        result.getContentPane().add((Component)panelButtons, "South");
        JPanel panelPart = new JPanel(new FlowLayout(0));
        panelButtons.add((Component)panelPart, "West");
        this.m_ButtonToggle = new JButton(TEXT_INTERACTIVE);
        this.m_ButtonToggle.setMnemonic('n');
        this.m_ButtonToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Inspect.this.m_ButtonToggle.getText().equals(Inspect.TEXT_INTERACTIVE)) {
                    Inspect.this.m_ButtonToggle.setText(Inspect.TEXT_NONINTERACTIVE);
                    Inspect.this.m_Interactive = false;
                    Inspect.this.m_Accepted = true;
                    Inspect.this.m_Waiting = false;
                } else {
                    Inspect.this.m_ButtonToggle.setText(Inspect.TEXT_INTERACTIVE);
                    Inspect.this.m_Interactive = true;
                }
            }
        });
        panelPart.add(this.m_ButtonToggle);
        panelPart = new JPanel(new FlowLayout(2));
        panelButtons.add((Component)panelPart, "East");
        this.m_ButtonSkip = new JButton(GUIHelper.stripMnemonic(this.m_LabelSkip));
        if (GUIHelper.hasMnemonic(this.m_LabelSkip)) {
            this.m_ButtonSkip.setMnemonic(GUIHelper.getMnemonic(this.m_LabelSkip));
        }
        this.m_ButtonSkip.setIcon(GUIHelper.getIcon("delete.gif"));
        this.m_ButtonSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspect.this.m_Accepted = false;
                Inspect.this.m_Waiting = false;
            }
        });
        panelPart.add(this.m_ButtonSkip);
        this.m_ButtonAccept = new JButton(GUIHelper.stripMnemonic(this.m_LabelAccept));
        if (GUIHelper.hasMnemonic(this.m_LabelAccept)) {
            this.m_ButtonAccept.setMnemonic(GUIHelper.getMnemonic(this.m_LabelAccept));
        }
        this.m_ButtonAccept.setIcon(GUIHelper.getIcon("accept.png"));
        this.m_ButtonAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspect.this.m_Accepted = true;
                Inspect.this.m_Waiting = false;
            }
        });
        panelPart.add(this.m_ButtonAccept);
        return result;
    }

    protected void updateButtons(boolean beforeDisplay) {
        if (!this.m_Interactive) {
            this.m_ButtonToggle.setEnabled(true);
            this.m_ButtonSkip.setEnabled(false);
            this.m_ButtonAccept.setEnabled(false);
        } else {
            this.m_ButtonToggle.setEnabled(true);
            this.m_ButtonSkip.setEnabled(beforeDisplay);
            this.m_ButtonAccept.setEnabled(beforeDisplay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doInteract() {
        boolean result = true;
        if (!this.m_Dialog.isVisible()) {
            this.updateButtons(false);
        }
        this.m_Dialog.setVisible(true);
        this.updateButtons(true);
        ((DisplayPanel)((Object)this.m_Panel)).display(this.m_InputToken);
        if (this.m_Interactive) {
            this.m_Waiting = true;
            while (this.m_Waiting.booleanValue() && !this.m_Stopped) {
                try {
                    Inspect inspect = this;
                    synchronized (inspect) {
                        this.wait(100L);
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        if (this.m_Accepted || !this.m_Interactive) {
            this.m_OutputToken = this.m_Panel instanceof UpdateableDisplayPanel ? ((UpdateableDisplayPanel)((Object)this.m_Panel)).getUpdatedToken() : this.m_InputToken;
        }
        this.updateButtons(false);
        return result;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Interactive = true;
        }
        return result;
    }

    @Override
    public void stopExecution() {
        if (this.m_Waiting != null) {
            this.m_Waiting = false;
        }
        super.stopExecution();
    }

    @Override
    public void wrapUp() {
        this.m_Waiting = null;
        if (this.m_Dialog != null && this.m_Dialog.isVisible()) {
            this.m_Dialog.setVisible(false);
        }
        super.wrapUp();
    }
}

