/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.MutableConnectedControlActor;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.Hashtable;

public class Sequence
extends MutableConnectedControlActor
implements InputConsumer {
    private static final long serialVersionUID = -9211041097478667239L;
    public static final String BACKUP_CURRENT = "current";
    protected transient Token m_CurrentToken;
    protected boolean m_AllowStandalones;
    protected boolean m_AllowSource;

    @Override
    public String globalInfo() {
        return "Encapsulates a sequence of flow items.";
    }

    @Override
    public String actorsTipText() {
        return "All the actors that define this sequence.";
    }

    public void setAllowStandalones(boolean value) {
        this.m_AllowStandalones = value;
    }

    public boolean getAllowStandalones() {
        return this.m_AllowStandalones;
    }

    public void setAllowSource(boolean value) {
        this.m_AllowSource = value;
    }

    public boolean getAllowSource() {
        return this.m_AllowSource;
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(this.m_AllowStandalones, this.m_AllowSource, ActorExecution.SEQUENTIAL, true);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_CurrentToken != null) {
            result.put(BACKUP_CURRENT, this.m_CurrentToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CURRENT)) {
            this.m_CurrentToken = (Token)state.get(BACKUP_CURRENT);
            this.input(this.m_CurrentToken);
            state.remove(BACKUP_CURRENT);
        }
        super.restoreState(state);
    }

    @Override
    public Class[] accepts() {
        Class[] result = new Class[]{Unknown.class};
        AbstractActor first = this.firstActive();
        if (first != null && first instanceof InputConsumer) {
            result = ((InputConsumer)((Object)first)).accepts();
        }
        return result;
    }

    @Override
    public void input(Token token) {
        this.m_CurrentToken = token;
        AbstractActor first = this.firstActive();
        if (this.isLoggingEnabled()) {
            this.getLogger().info("first active actor: " + (first == null ? "null" : first.getFullName()));
        }
        if (first != null && first instanceof InputConsumer) {
            ((InputConsumer)((Object)first)).input(this.m_CurrentToken);
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("input token: " + this.m_CurrentToken);
            }
        }
    }

    @Override
    protected String postExecute() {
        this.m_CurrentToken = null;
        return super.postExecute();
    }

    @Override
    public void wrapUp() {
        this.m_CurrentToken = null;
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        this.m_CurrentToken = null;
        super.cleanUp();
    }
}

