/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.AbstractTee;
import adams.flow.control.ConditionalTee;
import adams.flow.control.TimedTee;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.ActorWithConditionalEquivalent;
import adams.flow.core.ActorWithTimedEquivalent;
import adams.flow.core.Compatibility;
import adams.flow.core.InputConsumer;

public class Tee
extends AbstractTee
implements ActorWithConditionalEquivalent,
ActorWithTimedEquivalent {
    private static final long serialVersionUID = -7489525518244336025L;

    @Override
    public String globalInfo() {
        return "Allows to tap into the flow and tee-off tokens.";
    }

    @Override
    public Class getConditionalEquivalent() {
        return ConditionalTee.class;
    }

    @Override
    public Class getTimedEquivalent() {
        return TimedTee.class;
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        ActorHandlerInfo info = super.getActorHandlerInfo();
        return new ActorHandlerInfo(info.canContainStandalones(), false, info.getActorExecution(), info.getForwardsInput());
    }

    @Override
    protected String checkTeeActor(int index, AbstractActor actor) {
        if (ActorUtils.isSource(actor)) {
            return "You cannot add a source actor ('" + actor.getName() + "'/" + actor.getClass().getName() + ")!";
        }
        return null;
    }

    @Override
    protected String checkTeeActors(AbstractActor[] actors) {
        if (actors.length > 0) {
            for (int i = 0; i < actors.length; ++i) {
                if (actors[i].getSkip() || actors[i] instanceof InputConsumer) continue;
                return "You need to provide an actor that processes input, '" + actors[i].getName() + "'/" + actors[i].getClass().getName() + " doesn't!";
            }
        }
        return null;
    }

    @Override
    protected String setUpTeeActors() {
        String result = null;
        Compatibility comp = new Compatibility();
        if (!comp.isCompatible(this.accepts(), this.m_Actors.accepts())) {
            result = "Accepted input and tee actors are not compatible!";
        }
        return result;
    }
}

