/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.flow.control.StorageName;
import adams.flow.control.StorageQueueHandler;
import adams.flow.core.Actor;

public class QueueHelper {
    public static boolean hasQueue(Actor actor, StorageName queue) {
        return actor.getStorageHandler().getStorage().has(queue) && actor.getStorageHandler().getStorage().get(queue) instanceof StorageQueueHandler;
    }

    public static StorageQueueHandler getQueue(Actor actor, StorageName queue) {
        if (!QueueHelper.hasQueue(actor, queue)) {
            return null;
        }
        return (StorageQueueHandler)actor.getStorageHandler().getStorage().get(queue);
    }

    public static boolean enqueue(Actor actor, StorageName queue, Object payload) {
        if (!QueueHelper.hasQueue(actor, queue)) {
            return false;
        }
        return QueueHelper.getQueue(actor, queue).add(payload);
    }
}

