/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.base.BaseRegExp;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraversalPath;
import adams.core.option.OptionTraverser;
import adams.db.AbstractLimitedConditions;
import adams.flow.core.AbstractActor;
import adams.flow.processor.AbstractModifyingProcessor;
import java.lang.reflect.Array;

public class ChangeDatabaseConditionLimit
extends AbstractModifyingProcessor {
    private static final long serialVersionUID = -3031404150902143297L;
    protected int m_OldLimit;
    protected boolean m_ChangeAll;
    protected BaseRegExp m_RegExp;
    protected int m_NewLimit;

    @Override
    public String globalInfo() {
        return "Updates the limits of all database condition objects.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("old-limit", "oldLimit", -1, -1, null);
        this.m_OptionManager.add("change-all", "changeAll", false);
        this.m_OptionManager.add("reg-exp", "regExp", new BaseRegExp(".*"));
        this.m_OptionManager.add("new-limit", "newLimit", -1, -1, null);
    }

    public void setOldLimit(int value) {
        this.m_OldLimit = value;
        this.reset();
    }

    public int getOldLimit() {
        return this.m_OldLimit;
    }

    public String oldLimitTipText() {
        return "The old limit to replace.";
    }

    public void setChangeAll(boolean value) {
        this.m_ChangeAll = value;
        this.reset();
    }

    public boolean getChangeAll() {
        return this.m_ChangeAll;
    }

    public String changeAllTipText() {
        return "If enabled, any limit will get replaced with the new one, not just the ones that match the old limit.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression for the classnames to limit the update to.";
    }

    public void setNewLimit(int value) {
        this.m_NewLimit = value;
        this.reset();
    }

    public int getNewLimit() {
        return this.m_NewLimit;
    }

    public String newLimitTipText() {
        return "The new limit to set.";
    }

    @Override
    protected void processActor(AbstractActor actor) {
        actor.getOptionManager().traverse(new OptionTraverser(){

            protected void process(Object obj) {
                if (obj instanceof AbstractLimitedConditions) {
                    if (!ChangeDatabaseConditionLimit.this.m_RegExp.isMatch(obj.getClass().getName())) {
                        return;
                    }
                    AbstractLimitedConditions cond = (AbstractLimitedConditions)obj;
                    if (ChangeDatabaseConditionLimit.this.m_ChangeAll || !ChangeDatabaseConditionLimit.this.m_ChangeAll && ChangeDatabaseConditionLimit.this.m_OldLimit == cond.getLimit()) {
                        cond.setLimit(ChangeDatabaseConditionLimit.this.m_NewLimit);
                        ChangeDatabaseConditionLimit.this.m_Modified = true;
                    }
                }
            }

            @Override
            public void handleClassOption(ClassOption option, OptionTraversalPath path) {
                Object current = option.getCurrentValue();
                if (option.isMultiple()) {
                    for (int i = 0; i < Array.getLength(current); ++i) {
                        this.process(Array.get(current, i));
                    }
                } else {
                    this.process(current);
                }
            }

            @Override
            public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
            }

            @Override
            public boolean canHandle(AbstractOption option) {
                return true;
            }

            @Override
            public boolean canRecurse(Class cls) {
                return true;
            }

            @Override
            public boolean canRecurse(Object obj) {
                return this.canRecurse(obj.getClass());
            }
        });
    }
}

