/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.ClassLocator;
import adams.core.base.BaseObject;
import adams.core.option.AbstractArgumentOption;
import adams.flow.control.Flow;
import adams.flow.control.LocalScopeTrigger;
import adams.flow.control.StorageName;
import adams.flow.processor.AbstractNameUpdater;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class UpdateStorageName
extends AbstractNameUpdater<StorageName> {
    private static final long serialVersionUID = -5355023022079902959L;

    @Override
    public String globalInfo() {
        return "Updates all occurrences of the old storage name with the new one.";
    }

    @Override
    public String oldNameTipText() {
        return "The old storage name to replace with the new one.";
    }

    @Override
    public String newNameTipText() {
        return "The new storage name that replaces the old one.";
    }

    @Override
    protected boolean isBaseClassMatch(Class cls) {
        return cls.equals(StorageName.class);
    }

    @Override
    public boolean canRecurse(Class cls) {
        return !cls.equals(LocalScopeTrigger.class) && !cls.equals(Flow.class);
    }

    @Override
    protected boolean isNameMatch(StorageName old, String oldName) {
        return old.getValue().equals(oldName);
    }

    @Override
    protected StorageName getReplacement(StorageName old, String newName) {
        return new StorageName(newName);
    }

    protected boolean processBaseObject(AbstractArgumentOption option) {
        boolean result = false;
        StorageName oldName = new StorageName(this.m_OldName);
        if (option.isMultiple()) {
            Object array = option.getCurrentValue();
            boolean modified = false;
            for (int i = 0; i < Array.getLength(array); ++i) {
                BaseObject obj = (BaseObject)Array.get(array, i);
                if (!obj.equals(oldName)) continue;
                modified = true;
                obj = BaseObject.newInstance(option.getBaseClass(), obj.getValue().replace(this.m_OldName, this.m_NewName));
                Array.set(array, i, obj);
            }
            if (modified) {
                try {
                    Method method = option.getDescriptor().getWriteMethod();
                    method.invoke((Object)option.getOptionHandler(), array);
                    result = true;
                }
                catch (Exception e) {
                    System.err.println("Failed to update storage names in option " + option.getProperty() + "!");
                    e.printStackTrace();
                }
            }
        } else {
            BaseObject obj = (BaseObject)option.getCurrentValue();
            if (obj.equals(oldName)) {
                obj = BaseObject.newInstance(option.getBaseClass(), obj.getValue().replace(this.m_OldName, this.m_NewName));
                try {
                    Method method = option.getDescriptor().getWriteMethod();
                    method.invoke((Object)option.getOptionHandler(), obj);
                    result = true;
                }
                catch (Exception e) {
                    System.err.println("Failed to update storage names in option " + option.getProperty() + "!");
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    @Override
    protected void processArgumentOption(AbstractArgumentOption option) {
        super.processArgumentOption(option);
        if (ClassLocator.isSubclass(BaseObject.class, option.getBaseClass())) {
            this.m_Modified |= this.processBaseObject(option);
        }
    }
}

