/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.base.BaseCharset;
import adams.data.blob.BlobContainer;
import adams.flow.sink.AbstractFileWriter;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;

public class BinaryFileWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = 3613018887562327088L;
    protected BaseCharset m_Encoding;

    @Override
    public String globalInfo() {
        return "Writes a byte array or " + BlobContainer.class.getName() + " to a binary file.";
    }

    @Override
    public String outputFileTipText() {
        return "The name of the output file.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{byte[].class, BlobContainer.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doExecute() {
        String result = null;
        FilterOutputStream out = null;
        try {
            byte[] content = this.m_InputToken.getPayload() instanceof byte[] ? (byte[])this.m_InputToken.getPayload() : (byte[])((BlobContainer)this.m_InputToken.getPayload()).getContent();
            out = new BufferedOutputStream(new FileOutputStream(this.m_OutputFile.getAbsolutePath()));
            out.write(content);
            ((BufferedOutputStream)out).flush();
        }
        catch (Exception e) {
            result = this.handleException("Failed to write byte array to " + this.m_OutputFile, e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }
}

