/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.DOMNodeToString;
import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BasePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.dom.DOMTreeWithPreview;
import java.awt.Component;
import java.util.logging.Level;
import org.w3c.dom.Node;

public class DOMDisplay
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
TextSupplier {
    private static final long serialVersionUID = 680299970232233254L;
    protected DOMTreeWithPreview m_Tree;
    protected boolean m_Preview;
    protected boolean m_Expand;
    protected int m_SplitterPosition;

    @Override
    public String globalInfo() {
        return "Displays a DOM node object as tree structure.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("preview", "preview", false);
        this.m_OptionManager.add("expand", "expand", false);
        this.m_OptionManager.add("splitter-pos", "splitterPosition", this.getDefaultSplitterPosition(), 1, null);
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "preview", this.m_Preview, "preview", ", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "expand", this.m_Preview, "expand", ", ");
        return result;
    }

    public void setPreview(boolean value) {
        this.m_Preview = value;
        this.reset();
    }

    public boolean getPreview() {
        return this.m_Preview;
    }

    public String previewTipText() {
        return "If enabled, a table is shown that displays the attributes of the Node object associated with the currently selected node in the tree.";
    }

    public void setExpand(boolean value) {
        this.m_Expand = value;
        this.reset();
    }

    public boolean getExpand() {
        return this.m_Expand;
    }

    public String expandTipText() {
        return "If enabled, the tree gets fully expanded.";
    }

    protected int getDefaultSplitterPosition() {
        return 400;
    }

    public void setSplitterPosition(int value) {
        this.m_SplitterPosition = value;
        this.reset();
    }

    public int getSplitterPosition() {
        return this.m_SplitterPosition;
    }

    public String splitterPositionTipText() {
        return "The initial position of the splitter in the viewer panel.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Node.class};
    }

    @Override
    protected void display(Token token) {
        this.m_Tree.setDOM((Node)token.getPayload());
        if (this.m_Expand) {
            this.m_Tree.getTree().expandAll();
        }
    }

    @Override
    public void clearPanel() {
        if (this.m_Tree != null) {
            this.m_Tree.setDOM(null);
        }
    }

    @Override
    protected BasePanel newPanel() {
        this.m_Tree = new DOMTreeWithPreview();
        this.m_Tree.setPreviewVisible(this.m_Preview);
        this.m_Tree.setSplitterPosition(this.m_SplitterPosition);
        return this.m_Tree;
    }

    @Override
    public ExtensionFileFilter getCustomTextFileFilter() {
        return new ExtensionFileFilter("XML", "xml");
    }

    @Override
    public String supplyText() {
        String result = null;
        if (this.m_Tree != null) {
            try {
                DOMNodeToString conv = new DOMNodeToString();
                conv.setInput(this.m_Tree.getDOM());
                String msg = conv.convert();
                if (msg == null) {
                    result = (String)conv.getOutput();
                } else {
                    this.getLogger().severe("Failed to convert value to string: " + msg);
                }
                conv.cleanUp();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to convert value to string:", e);
                result = null;
            }
        }
        return result;
    }

    @Override
    public DisplayPanel createDisplayPanel(Token token) {
        AbstractTextDisplayPanel result = new AbstractTextDisplayPanel(this.getClass().getSimpleName()){
            private static final long serialVersionUID = 4356468458332186521L;
            protected DOMTreeWithPreview m_Tree;

            @Override
            protected void initGUI() {
                super.initGUI();
                this.m_Tree = new DOMTreeWithPreview();
                this.m_Tree.setPreviewVisible(DOMDisplay.this.m_Preview);
                this.add((Component)this.m_Tree, "Center");
            }

            @Override
            public void display(Token token) {
                this.m_Tree.setDOM((Node)token.getPayload());
                this.m_Tree.setSplitterPosition(DOMDisplay.this.m_SplitterPosition);
                if (DOMDisplay.this.m_Expand) {
                    this.m_Tree.getTree().expandAll();
                }
            }

            @Override
            public void clearPanel() {
                this.m_Tree.setDOM(null);
            }

            @Override
            public void cleanUp() {
                this.m_Tree.setDOM(null);
            }

            @Override
            public ExtensionFileFilter getCustomTextFileFilter() {
                return new ExtensionFileFilter("XML", "xml");
            }

            @Override
            public String supplyText() {
                if (this.m_Tree != null) {
                    try {
                        DOMNodeToString conv = new DOMNodeToString();
                        conv.setInput(this.m_Tree.getDOM());
                        String msg = conv.convert();
                        conv.cleanUp();
                        if (msg == null) {
                            return (String)conv.getOutput();
                        }
                        DOMDisplay.this.getLogger().severe("Failed to convert value to string: " + msg);
                    }
                    catch (Exception e) {
                        DOMDisplay.this.getLogger().log(Level.SEVERE, "Failed to convert value to string:", e);
                    }
                }
                return null;
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    @Override
    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

