/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUpdater;
import adams.flow.core.QueueHelper;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.sink.AbstractSink;

public class EnQueue
extends AbstractSink
implements StorageUpdater {
    private static final long serialVersionUID = -2091772083812307932L;
    protected StorageName m_StorageName;

    @Override
    public String globalInfo() {
        return "Enqueues the incoming data in the specified queue in internal storage.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", new StorageName("queue"));
    }

    @Override
    public boolean isUpdatingStorage() {
        return !this.getSkip();
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "storageName", this.m_StorageName, "storage: ");
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the queue in the internal storage.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        if (QueueHelper.hasQueue(this, this.m_StorageName)) {
            QueueHelper.enqueue(this, this.m_StorageName, token.getPayload());
        }
    }

    @Override
    protected String doExecute() {
        return null;
    }
}

