/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.canvas;

import adams.flow.sink.canvas.AbstractDataPoolPaintlet;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class XYPaintlet
extends AbstractDataPoolPaintlet {
    private static final long serialVersionUID = -7454325864276285119L;

    @Override
    public String globalInfo() {
        return "Simply paints dots for the X and Y coordinates.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Double[].class};
    }

    @Override
    public void prepareUpdate() {
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (Object o : this.getDataPool()) {
            Double[] coords = (Double[])o;
            if (coords[0] < minX) {
                minX = coords[0];
            }
            if (coords[0] > maxX) {
                maxX = coords[0];
            }
            if (coords[1] < minY) {
                minY = coords[1];
            }
            if (!(coords[1] > maxY)) continue;
            maxY = coords[1];
        }
        this.getPlot().getAxis(Axis.BOTTOM).setMinimum(minX);
        this.getPlot().getAxis(Axis.BOTTOM).setMaximum(maxX);
        this.getPlot().getAxis(Axis.LEFT).setMinimum(minY);
        this.getPlot().getAxis(Axis.LEFT).setMaximum(maxY);
    }

    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        AxisPanel x = this.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel y = this.getPlot().getAxis(Axis.LEFT);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.RED);
        g2d.setStroke(new BasicStroke(2.0f));
        for (Object o : this.getDataPool()) {
            Double[] coords = (Double[])o;
            g2d.drawOval(x.valueToPos(coords[0]), y.valueToPos(coords[1]), 4, 4);
        }
    }
}

