/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.management.OS;
import adams.core.management.ProcessUtils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.conversion.ConversionFromString;
import adams.data.conversion.StringToString;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import java.util.ArrayList;
import java.util.List;

public class Exec
extends AbstractSource {
    private static final long serialVersionUID = -132045002653940359L;
    protected String m_Command;
    protected boolean m_CommandContainsPlaceholder;
    protected boolean m_CommandContainsVariable;
    protected boolean m_OutputStdErr;
    protected boolean m_SplitOutput;
    protected ConversionFromString m_Conversion;
    protected List m_Output;

    @Override
    public String globalInfo() {
        return "Runs an external system command and broadcasts the generated output (stdout or stderr).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cmd", "command", "ls -l .");
        this.m_OptionManager.add("placeholder", "commandContainsPlaceholder", false);
        this.m_OptionManager.add("variable", "commandContainsVariable", false);
        this.m_OptionManager.add("stderr", "outputStdErr", false);
        this.m_OptionManager.add("split-output", "splitOutput", false);
        this.m_OptionManager.add("conversion", "conversion", new StringToString());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Output = new ArrayList();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Output.clear();
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "command", this.m_Command);
    }

    public void setCommand(String value) {
        this.m_Command = value;
        this.reset();
    }

    public String getCommand() {
        return this.m_Command;
    }

    public String commandTipText() {
        return "The external command to run.";
    }

    public void setCommandContainsPlaceholder(boolean value) {
        this.m_CommandContainsPlaceholder = value;
        this.reset();
    }

    public boolean getCommandContainsPlaceholder() {
        return this.m_CommandContainsPlaceholder;
    }

    public String commandContainsPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion for the command string.";
    }

    public void setCommandContainsVariable(boolean value) {
        this.m_CommandContainsVariable = value;
        this.reset();
    }

    public boolean getCommandContainsVariable() {
        return this.m_CommandContainsVariable;
    }

    public String commandContainsVariableTipText() {
        return "Set this to true to enable automatic variable expansion for the command string.";
    }

    public void setOutputStdErr(boolean value) {
        this.m_OutputStdErr = value;
        this.reset();
    }

    public boolean getOutputStdErr() {
        return this.m_OutputStdErr;
    }

    public String outputStdErrTipText() {
        return "If set to true, then stderr is output instead of stdout.";
    }

    public void setSplitOutput(boolean value) {
        this.m_SplitOutput = value;
        this.reset();
    }

    public boolean getSplitOutput() {
        return this.m_SplitOutput;
    }

    public String splitOutputTipText() {
        return "If set to true, then the output gets split on " + (OS.isWindows() ? "CRLF" : "newline") + ".";
    }

    public void setConversion(ConversionFromString value) {
        this.m_Conversion = value;
        this.reset();
    }

    public ConversionFromString getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion scheme to apply to the output.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{this.m_Conversion.generates()};
    }

    @Override
    protected String doExecute() {
        String result = null;
        this.m_Output.clear();
        String cmd = this.m_Command;
        if (this.m_CommandContainsVariable) {
            cmd = this.getVariables().expand(cmd);
        }
        if (this.m_CommandContainsPlaceholder) {
            cmd = Placeholders.getSingleton().expand(cmd).replace("\\", "/");
        }
        try {
            ProcessUtils.ProcessResult proc = ProcessUtils.execute(OptionUtils.splitOptions(cmd));
            if (!proc.hasSucceeded()) {
                result = proc.toErrorOutput();
            } else {
                String output = this.m_OutputStdErr ? proc.getStdErr() : proc.getStdOut();
                String[] items = this.m_SplitOutput ? (OS.isWindows() ? output.split("\r\n") : output.split("\n")) : new String[]{output};
                for (String item : items) {
                    this.m_Conversion.setInput(item);
                    String msg = this.m_Conversion.convert();
                    if (msg == null) {
                        this.m_Output.add(this.m_Conversion.getOutput());
                        continue;
                    }
                    this.getLogger().severe("Failed to convert '" + item + "'!");
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute command: " + cmd, e);
        }
        return result;
    }

    @Override
    public Token output() {
        Token result = new Token(this.m_Output.get(0));
        this.m_Output.remove(0);
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Output.size() > 0;
    }
}

