/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.filesystemsearch;

import adams.flow.source.filesystemsearch.AbstractFileSystemSearchlet;
import java.util.ArrayList;
import java.util.List;

public class MultiSearch
extends AbstractFileSystemSearchlet {
    private static final long serialVersionUID = -3189597528629633942L;
    protected AbstractFileSystemSearchlet[] m_Searches;

    @Override
    public String globalInfo() {
        return "Combines the search results of multiple search algorithms.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("search", "searches", new AbstractFileSystemSearchlet[0]);
    }

    public void setSearches(AbstractFileSystemSearchlet[] value) {
        this.m_Searches = value;
        this.reset();
    }

    public AbstractFileSystemSearchlet[] getSearches() {
        return this.m_Searches;
    }

    public String searchesTipText() {
        return "The search algorithms to execute.";
    }

    @Override
    protected void check() throws Exception {
        super.check();
        if (this.m_Searches.length == 0) {
            throw new IllegalStateException("At least one search algorithm must be supplied!");
        }
    }

    @Override
    protected List<String> doSearch() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.m_Searches.length; ++i) {
            try {
                result.addAll(this.m_Searches[i].search());
                continue;
            }
            catch (Exception e) {
                throw new Exception("Failed to execute search #" + (i + 1), e);
            }
        }
        return result;
    }
}

