/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractDisplay;
import adams.flow.sink.TextSupplier;
import adams.gui.chooser.TextFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.ConsolePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.event.ConsolePanelEvent;
import adams.gui.event.ConsolePanelListener;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConsoleWindow
extends AbstractDisplay
implements ConsolePanelListener,
MenuBarProvider,
TextSupplier,
SendToActionSupporter {
    private static final long serialVersionUID = 4306748076674344994L;
    public static final String BACKUP_INPUT = "lookup";
    protected ConsolePanel.OutputType[] m_Types;
    protected Font m_Font;
    protected BaseTextArea m_TextArea;
    protected HashSet<ConsolePanel.OutputType> m_LookUp;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileClear;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileClose;
    protected transient TextFileChooser m_FileChooser;

    @Override
    public String globalInfo() {
        return "Displays the messages that are output in the system's 'Console window'.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "types", new ConsolePanel.OutputType[]{ConsolePanel.OutputType.INFO, ConsolePanel.OutputType.DEBUG, ConsolePanel.OutputType.ERROR});
        this.m_OptionManager.add("font", "font", this.getDefaultFont());
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_LookUp = null;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_INPUT);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_LookUp != null) {
            result.put(BACKUP_INPUT, this.m_LookUp);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_LookUp = (HashSet)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    public void setTypes(ConsolePanel.OutputType[] value) {
        this.m_Types = value;
        this.reset();
    }

    public ConsolePanel.OutputType[] getTypes() {
        return this.m_Types;
    }

    public String typesTipText() {
        return "The types of messages to display.";
    }

    protected Font getDefaultFont() {
        return new Font("Monospaced", 0, 12);
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font of the dialog.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "types", Utils.flatten((Object[])this.m_Types, ", "));
    }

    protected TextFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            TextFileChooser fileChooser = new TextFileChooser();
            ExtensionFileFilter filter = null;
            if (this instanceof TextSupplier) {
                filter = this.getCustomTextFileFilter();
            }
            if (filter != null) {
                fileChooser.resetChoosableFileFilters();
                fileChooser.addChoosableFileFilter(filter);
                fileChooser.setFileFilter(filter);
                fileChooser.setDefaultExtension(filter.getExtensions()[0]);
            }
            this.m_FileChooser = fileChooser;
        }
        return this.m_FileChooser;
    }

    @Override
    public void clearPanel() {
        if (this.m_TextArea != null) {
            this.m_TextArea.setText("");
        }
    }

    protected JMenu createFileMenu() {
        JMenuItem menuitem;
        JMenu result = new JMenu("File");
        result.setMnemonic('F');
        result.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConsoleWindow.this.updateMenu();
            }
        });
        if (this.supportsClear()) {
            menuitem = new JMenuItem("Clear");
            result.add(menuitem);
            menuitem.setMnemonic('l');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed N"));
            menuitem.setIcon(GUIHelper.getIcon("new.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConsoleWindow.this.clear();
                }
            });
            this.m_MenuItemFileClear = menuitem;
        }
        menuitem = new JMenuItem("Save as...");
        result.add(menuitem);
        menuitem.setMnemonic('a');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed S"));
        menuitem.setIcon(GUIHelper.getIcon("save.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleWindow.this.saveAs();
            }
        });
        this.m_MenuItemFileSaveAs = menuitem;
        result.addSeparator();
        if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, result)) {
            result.addSeparator();
        }
        menuitem = new JMenuItem("Close");
        result.add(menuitem);
        menuitem.setMnemonic('C');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
        menuitem.setIcon(GUIHelper.getIcon("exit.png"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleWindow.this.close();
            }
        });
        this.m_MenuItemFileClose = menuitem;
        return result;
    }

    protected int indexOfMenuItem(JMenu menu, JMenuItem menuitem) {
        int result = -1;
        for (int i = 0; i < menu.getItemCount(); ++i) {
            if (menu.getItem(i) != menuitem) continue;
            result = i;
            break;
        }
        return result;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar result = new JMenuBar();
        result.add(this.createFileMenu());
        return result;
    }

    @Override
    public JMenuBar getMenuBar() {
        if (this.m_MenuBar == null) {
            this.m_MenuBar = this.createMenuBar();
            this.updateMenu();
        }
        return this.m_MenuBar;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        String text = this.supplyText();
        int len = text == null ? 0 : text.length();
        if (this.supportsClear()) {
            this.m_MenuItemFileClear.setEnabled(len > 0);
        }
        this.m_MenuItemFileSaveAs.setEnabled(len > 0);
    }

    protected boolean supportsClear() {
        return true;
    }

    protected void clear() {
        this.clearPanel();
    }

    protected void saveAs() {
        int retVal = this.getFileChooser().showSaveDialog(this.m_Panel);
        if (retVal != 0) {
            return;
        }
        FileUtils.writeToFile(this.getFileChooser().getSelectedFile().getAbsolutePath(), this.supplyText(), false, this.getFileChooser().getEncoding());
    }

    protected void close() {
        this.m_Panel.closeParent();
    }

    @Override
    public ExtensionFileFilter getCustomTextFileFilter() {
        return null;
    }

    @Override
    public String supplyText() {
        if (this.m_TextArea == null) {
            return null;
        }
        return this.m_TextArea.getText();
    }

    @Override
    protected BasePanel newPanel() {
        BasePanel result = new BasePanel(new BorderLayout());
        this.m_TextArea = new BaseTextArea();
        this.m_TextArea.setFont(this.m_Font);
        result.add((Component)new BaseScrollPane(this.m_TextArea), "Center");
        return result;
    }

    @Override
    protected Runnable newDisplayRunnable() {
        Runnable result = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ConsoleWindow.this.m_CreateFrame && !ConsoleWindow.this.m_Frame.isVisible()) {
                    ConsoleWindow.this.m_Frame.setVisible(true);
                }
                AbstractActor abstractActor = ConsoleWindow.this.m_Self;
                synchronized (abstractActor) {
                    ConsoleWindow.this.m_Self.notifyAll();
                }
                ConsoleWindow.this.m_Updating = false;
            }
        };
        return result;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && !this.m_Headless) {
            ConsolePanel.getSingleton().addListener(this);
            this.m_LookUp = new HashSet<ConsolePanel.OutputType>(Arrays.asList(this.m_Types));
        }
        return result;
    }

    @Override
    public void consolePanelMessageReceived(ConsolePanelEvent e) {
        if (this.m_LookUp.contains((Object)e.getOutputType()) && this.m_TextArea != null) {
            this.m_TextArea.append(e.getMessage());
        }
    }

    @Override
    public void wrapUp() {
        if (!this.m_Headless) {
            ConsolePanel.getSingleton().removeListener(this);
        }
        if (this.m_LookUp != null) {
            this.m_LookUp = null;
        }
        super.wrapUp();
    }

    @Override
    protected void cleanUpGUI() {
        super.cleanUpGUI();
        this.m_MenuBar = null;
        this.m_MenuItemFileClear = null;
        this.m_MenuItemFileSaveAs = null;
        this.m_MenuItemFileClose = null;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_FileChooser = null;
    }

    @Override
    public Class[] getSendToClasses() {
        return new Class[]{String.class};
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable(String.class, cls);
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        String result = null;
        if (SendToActionUtils.isAvailable(String.class, cls) && (result = this.supplyText()).length() == 0) {
            result = null;
        }
        return result;
    }
}

