/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.db.AbstractDatabaseConnection;
import adams.db.SQL;
import adams.db.SQLStatement;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.standalone.DatabaseConnection;
import java.util.logging.Level;

public class ExecSQL
extends AbstractStandalone {
    private static final long serialVersionUID = -2766505525494708760L;
    protected SQLStatement m_SQL;
    protected boolean m_DryRun;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    @Override
    public String globalInfo() {
        return "Executes a SQL statement, which does not return a result set, like INSERT, UPDATE, DELETE, CREATE.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sql", "SQL", new SQLStatement(""));
        this.m_OptionManager.add("dry-run", "dryRun", false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "SQL", Utils.shorten(this.m_SQL.getValue().replaceAll("\\s", " ").replaceAll("[ ]+", " "), 50));
        String value = QuickInfoHelper.toString((OptionHandler)this, "dryRun", this.m_DryRun, "dry run", result != null ? ", " : "");
        if (value != null) {
            result = result == null ? value : result + value;
        }
        return result;
    }

    public void setSQL(SQLStatement value) {
        this.m_SQL = value;
        this.reset();
    }

    public SQLStatement getSQL() {
        return this.m_SQL;
    }

    public String SQLTipText() {
        return "The SQL statement to run that generates the IDs.";
    }

    public void setDryRun(boolean value) {
        this.m_DryRun = value;
        this.reset();
    }

    public boolean getDryRun() {
        return this.m_DryRun;
    }

    public String dryRunTipText() {
        return "If enabled, the SQL statement is merely logged but not executed.";
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection(this, DatabaseConnection.class, adams.db.DatabaseConnection.getSingleton());
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        String query = this.m_SQL.getValue();
        query = this.getVariables().expand(query);
        try {
            SQL sql = new SQL(this.getDatabaseConnection());
            if (this.isLoggingEnabled() || this.m_DryRun) {
                if (this.m_DryRun) {
                    this.getLogger().setLevel(Level.INFO);
                }
                this.getLogger().info("Query: " + query);
                if (this.m_DryRun) {
                    this.getLogger().setLevel(this.getLoggingLevel().getLevel());
                }
            }
            if (!this.m_DryRun && sql.execute(query) == null) {
                result = "Failed to execute query: " + query;
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute query '" + query + "': ", e);
        }
        return result;
    }
}

