/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.db.LogEntry;
import adams.flow.control.StorageName;
import adams.flow.control.StorageQueueHandler;
import adams.flow.control.StorageUpdater;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.CallableActorUser;
import adams.flow.standalone.AbstractStandalone;
import java.util.Hashtable;

public class QueueInit
extends AbstractStandalone
implements StorageUpdater,
CallableActorUser {
    private static final long serialVersionUID = 4182914190162129217L;
    public static final String BACKUP_LOGACTOR = "log actor";
    public static final String BACKUP_MONITORACTOR = "monitor actor";
    protected StorageName m_StorageName;
    protected boolean m_KeepExisting;
    protected int m_Limit;
    protected CallableActorReference m_Log;
    protected AbstractActor m_LogActor;
    protected CallableActorReference m_Monitor;
    protected AbstractActor m_MonitorActor;
    protected CallableActorHelper m_Helper;

    @Override
    public String globalInfo() {
        return "Creates an empty queue in internal storage under the specified name.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", new StorageName("queue"));
        this.m_OptionManager.add("keep-existing", "keepExisting", false);
        this.m_OptionManager.add("limit", "limit", -1, -1, null);
        this.m_OptionManager.add("log", "log", new CallableActorReference("unknown"));
        this.m_OptionManager.add("monitor", "monitor", new CallableActorReference("unknown"));
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_LogActor = null;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    @Override
    public boolean isUpdatingStorage() {
        return !this.getSkip();
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "storageName", this.m_StorageName, "storage: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "keepExisting", this.m_KeepExisting, "keep", ", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "limit", this.m_Limit, ", limit: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "log", this.m_Log, ", log: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "monitor", this.m_Monitor, ", monitor: ");
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the queue in the internal storage.";
    }

    public void setKeepExisting(boolean value) {
        this.m_KeepExisting = value;
        this.reset();
    }

    public boolean getKeepExisting() {
        return this.m_KeepExisting;
    }

    public String keepExistingTipText() {
        return "If enabled, existing queues won't get re-initialized.";
    }

    public void setLimit(int value) {
        if (value <= 0) {
            value = -1;
        }
        this.m_Limit = value;
        this.reset();
    }

    public int getLimit() {
        return this.m_Limit;
    }

    public String limitTipText() {
        return "The limit of the queue; use <= 0 for unlimited size.";
    }

    public void setLog(CallableActorReference value) {
        this.m_Log = value;
        this.reset();
    }

    public CallableActorReference getLog() {
        return this.m_Log;
    }

    public String logTipText() {
        return "The name of the (optional) callable actor to use for logging errors of type " + LogEntry.class.getName() + ".";
    }

    public void setMonitor(CallableActorReference value) {
        this.m_Monitor = value;
        this.reset();
    }

    public CallableActorReference getMonitor() {
        return this.m_Monitor;
    }

    public String monitorTipText() {
        return "The name of the (optional) callable actor to use for monitoring; generates tokens of type " + LogEntry.class.getName() + ".";
    }

    protected AbstractActor findCallableActor(CallableActorReference name) {
        return this.m_Helper.findCallableActorRecursive(this, name);
    }

    @Override
    public AbstractActor getCallableActor() {
        return this.m_LogActor;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_LOGACTOR);
        this.pruneBackup(BACKUP_MONITORACTOR);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_LogActor != null) {
            result.put(BACKUP_LOGACTOR, this.m_LogActor);
        }
        if (this.m_MonitorActor != null) {
            result.put(BACKUP_MONITORACTOR, this.m_MonitorActor);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        super.restoreState(state);
        if (state.containsKey(BACKUP_LOGACTOR)) {
            this.m_LogActor = (AbstractActor)state.get(BACKUP_LOGACTOR);
            state.remove(BACKUP_LOGACTOR);
        }
        if (state.containsKey(BACKUP_MONITORACTOR)) {
            this.m_MonitorActor = (AbstractActor)state.get(BACKUP_MONITORACTOR);
            state.remove(BACKUP_MONITORACTOR);
        }
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_LogActor = this.findCallableActor(this.getLog());
            this.m_MonitorActor = this.findCallableActor(this.getMonitor());
        }
        return result;
    }

    @Override
    protected String doExecute() {
        if (this.m_KeepExisting && !this.getStorageHandler().getStorage().has(this.m_StorageName) || !this.m_KeepExisting) {
            StorageQueueHandler handler = new StorageQueueHandler(this.m_StorageName.getValue(), this.m_Limit, this.m_LogActor, this.m_MonitorActor);
            handler.setLoggingLevel(this.getLoggingLevel());
            this.getStorageHandler().getStorage().put(this.m_StorageName, handler);
        }
        return null;
    }
}

