/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.template;

import adams.flow.condition.bool.Counting;
import adams.flow.control.Count;
import adams.flow.core.AbstractActor;
import adams.flow.sink.Console;
import adams.flow.template.AbstractActorTemplate;

public class ProgressInConsole
extends AbstractActorTemplate {
    private static final long serialVersionUID = 2310015199489870240L;
    protected int m_Interval;
    protected String m_Prefix;

    @Override
    public String globalInfo() {
        return "Generates a sub-flow that outputs the token count every X number of tokens, with X being the interval supplied to this template.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("interval", "interval", 100, 1, null);
        this.m_OptionManager.add("prefix", "prefix", "# of tokens: ");
    }

    public void setInterval(int value) {
        this.m_Interval = value;
        this.reset();
    }

    public int getInterval() {
        return this.m_Interval;
    }

    public String intervalTipText() {
        return "The interval for the progress info.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use in the console.";
    }

    @Override
    protected AbstractActor doGenerate() {
        Counting cnt = new Counting();
        cnt.setInterval(this.m_Interval);
        Count result = new Count();
        result.setCondition(cnt);
        result.setName("Progress info");
        Console con = new Console();
        con.setPrefix(this.m_Prefix);
        result.add(con);
        return result;
    }
}

