/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUpdater;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class IncStorageValue
extends AbstractTransformer
implements StorageUpdater {
    private static final long serialVersionUID = 4563837784851442207L;
    protected StorageName m_StorageName;
    protected IncrementType m_IncrementType;
    protected int m_IntegerIncrement;
    protected double m_DoubleIncrement;

    @Override
    public String globalInfo() {
        return "Increments the value of a storage value by either an integer or double increment.\nIf the storage value has not been set yet, it will get set to 0.\nIf the storage value contains a non-numerical value, no increment will be performed.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", new StorageName());
        this.m_OptionManager.add("inc-type", "incrementType", (Object)IncrementType.INTEGER);
        this.m_OptionManager.add("inc-int", "integerIncrement", 1);
        this.m_OptionManager.add("inc-double", "doubleIncrement", 1.0);
    }

    @Override
    public boolean isUpdatingStorage() {
        return !this.getSkip();
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "storageName", this.m_StorageName);
        String variable = QuickInfoHelper.getVariable(this, "incrementType");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "incrementType", (Object)this.m_IncrementType, ", ");
        if (variable == null) {
            result = result + ", inc: ";
            switch (this.m_IncrementType) {
                case INTEGER: {
                    result = result + QuickInfoHelper.toString((OptionHandler)this, "integerIncrement", this.m_IntegerIncrement);
                    break;
                }
                case DOUBLE: {
                    result = result + QuickInfoHelper.toString((OptionHandler)this, "doubleIncrement", this.m_DoubleIncrement);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled increment type: " + (Object)((Object)this.m_IncrementType));
                }
            }
        }
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the storage value to increment.";
    }

    public void setIncrementType(IncrementType value) {
        this.m_IncrementType = value;
        this.reset();
    }

    public IncrementType getIncrementType() {
        return this.m_IncrementType;
    }

    public String incrementTypeTipText() {
        return "The type of increment to perform.";
    }

    public void setIntegerIncrement(int value) {
        this.m_IntegerIncrement = value;
        this.reset();
    }

    public int getIntegerIncrement() {
        return this.m_IntegerIncrement;
    }

    public String integerIncrementTipText() {
        return "The increment in case of " + (Object)((Object)IncrementType.INTEGER) + " increments.";
    }

    public void setDoubleIncrement(double value) {
        this.m_DoubleIncrement = value;
        this.reset();
    }

    public double getDoubleIncrement() {
        return this.m_DoubleIncrement;
    }

    public String doubleIncrementTipText() {
        return "The increment in case of " + (Object)((Object)IncrementType.DOUBLE) + " increments.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        Number value;
        String result;
        block17: {
            result = null;
            try {
                if (this.getStorageHandler().getStorage().has(this.m_StorageName)) {
                    switch (this.m_IncrementType) {
                        case INTEGER: {
                            value = (Integer)this.getStorageHandler().getStorage().get(this.m_StorageName);
                            break block17;
                        }
                        case DOUBLE: {
                            value = (Double)this.getStorageHandler().getStorage().get(this.m_StorageName);
                            break block17;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled increment type: " + (Object)((Object)this.m_IncrementType));
                        }
                    }
                }
                switch (this.m_IncrementType) {
                    case INTEGER: {
                        value = new Integer(0);
                        break;
                    }
                    case DOUBLE: {
                        value = new Double(0.0);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled increment type: " + (Object)((Object)this.m_IncrementType));
                    }
                }
            }
            catch (Exception e) {
                value = null;
            }
        }
        if (value != null) {
            switch (this.m_IncrementType) {
                case INTEGER: {
                    value = new Integer(value.intValue() + this.m_IntegerIncrement);
                    break;
                }
                case DOUBLE: {
                    value = new Double(value.doubleValue() + this.m_DoubleIncrement);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled increment type: " + (Object)((Object)this.m_IncrementType));
                }
            }
            this.getStorageHandler().getStorage().put(this.m_StorageName, value);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Incremented storage '" + this.m_StorageName + "': " + value);
            }
        }
        this.m_OutputToken = this.m_InputToken;
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    public static enum IncrementType {
        INTEGER,
        DOUBLE;

    }
}

