/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.util.ArrayList;

public class MoveFile
extends AbstractTransformer {
    private static final long serialVersionUID = -1725398133887399010L;
    protected PlaceholderFile m_File;
    protected boolean m_InputIsTarget;

    @Override
    public String globalInfo() {
        return "Moves a file to a different location (or just renames it).\nSource and target can be swapped as well.\nSimply forwards the input token if moving was successful.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "file", new PlaceholderFile("."));
        this.m_OptionManager.add("input-is-target", "inputIsTarget", false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "file", this.m_File);
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "inputIsTarget", this.m_InputIsTarget, "input is target"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setFile(PlaceholderFile value) {
        this.m_File = value;
        this.reset();
    }

    public PlaceholderFile getFile() {
        return this.m_File;
    }

    public String fileTipText() {
        return "The target file or directory.";
    }

    public void setInputIsTarget(boolean value) {
        this.m_InputIsTarget = value;
        this.reset();
    }

    public boolean getInputIsTarget() {
        return this.m_InputIsTarget;
    }

    public String inputIsTargetTipText() {
        return "If true, then the input token will be used as target and the file parameter as source.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        PlaceholderFile source = null;
        PlaceholderFile target = null;
        try {
            PlaceholderFile file = this.m_InputToken.getPayload() instanceof File ? new PlaceholderFile((File)this.m_InputToken.getPayload()) : new PlaceholderFile((String)this.m_InputToken.getPayload());
            if (this.m_InputIsTarget) {
                target = file;
                source = this.m_File;
            } else {
                target = this.m_File;
                source = file;
            }
            this.getLogger().info("Source '" + source + "' exists: " + ((File)source).exists());
            this.getLogger().info("Target '" + target + "' exists: " + ((File)target).exists());
            if (!FileUtils.move(source.getAbsoluteFile(), target.getAbsoluteFile())) {
                result = "Failed to move file: " + source + " -> " + target;
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to move file: " + source + " -> " + target, e);
        }
        if (result == null) {
            this.m_OutputToken = new Token(this.m_InputToken.getPayload());
        }
        return result;
    }
}

