/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Properties;

public class SetPropertyValue
extends AbstractTransformer {
    private static final long serialVersionUID = -5937471470417243026L;
    protected String m_Key;
    protected String m_Value;

    @Override
    public String globalInfo() {
        return "Sets a property in a properties object.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key", "key", "");
        this.m_OptionManager.add("value", "value", "");
    }

    public void setKey(String value) {
        this.m_Key = value;
        this.reset();
    }

    public String getKey() {
        return this.m_Key;
    }

    public String keyTipText() {
        return "The key of the property to set.";
    }

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The value of the property to set.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Properties.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Properties.class};
    }

    @Override
    public String getQuickInfo() {
        String result = null;
        String value = QuickInfoHelper.toString((OptionHandler)this, "key", this.m_Key);
        if (value != null) {
            result = value;
            result = result + " = ";
            value = QuickInfoHelper.toString((OptionHandler)this, "value", this.m_Value);
            if (value != null) {
                result = result + value;
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        Properties props = (Properties)this.m_InputToken.getPayload();
        props.setProperty(this.m_Key, this.m_Value);
        this.m_OutputToken = new Token(props);
        return result;
    }
}

