/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Compatibility;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class SetReportFromSource
extends AbstractTransformer {
    private static final long serialVersionUID = -8951982264797087668L;
    protected CallableActorReference m_Report;
    protected CallableActorHelper m_Helper;

    @Override
    public String globalInfo() {
        return "Obtains a report from a callable source and replaces the current one in the token passing through.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("report", "report", new CallableActorReference("unknown"));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    public void setReport(CallableActorReference value) {
        this.m_Report = value;
        this.reset();
    }

    public CallableActorReference getReport() {
        return this.m_Report;
    }

    public String reportTipText() {
        return "The callable source to obtain the report from.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "report", this.m_Report);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{MutableReportHandler.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{MutableReportHandler.class};
    }

    @Override
    public String setUp() {
        String variable;
        String result = super.setUp();
        if (result == null && (variable = this.getOptionManager().getVariableForProperty("report")) == null && this.m_Report.isEmpty()) {
            result = "No report source specified!";
        }
        return result;
    }

    protected AbstractActor findCallableActor() {
        return this.m_Helper.findCallableActorRecursive(this, this.getReport());
    }

    @Override
    protected String doExecute() {
        String result = null;
        MutableReportHandler handler = (MutableReportHandler)this.m_InputToken.getPayload();
        AbstractActor source = this.findCallableActor();
        if (source instanceof OutputProducer) {
            Compatibility comp = new Compatibility();
            if (!comp.isCompatible(new Class[]{Report.class}, ((OutputProducer)((Object)source)).generates())) {
                result = "Callable actor '" + this.m_Report + "' does not produce output that is compatible with '" + Report.class.getName() + "'!";
            }
        } else {
            result = "Callable actor '" + this.m_Report + "' does not produce any output!";
        }
        Token token = null;
        if (result == null) {
            result = source.execute();
            if (result != null) {
                result = "Callable actor '" + this.m_Report + "' execution failed:\n" + result;
            } else if (((OutputProducer)((Object)source)).hasPendingOutput()) {
                token = ((OutputProducer)((Object)source)).output();
            } else {
                result = "Callable actor '" + this.m_Report + "' did not generate any output!";
            }
        }
        if (result == null) {
            handler.setReport((Report)token.getPayload());
            this.m_OutputToken = new Token(handler);
        }
        return result;
    }
}

