/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseCharset;
import adams.core.io.FileEncodingSupporter;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.io.input.AbstractTextReader;
import adams.data.io.input.LineArrayTextReader;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class TextFileReader
extends AbstractTransformer
implements FileEncodingSupporter {
    private static final long serialVersionUID = -184602726110144511L;
    protected AbstractTextReader m_Reader;
    protected BaseCharset m_Encoding;

    @Override
    public String globalInfo() {
        return "Reads a text file and forwards the content.\nThis actor takes the file to read as input.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", new LineArrayTextReader());
        this.m_OptionManager.add("encoding", "encoding", new BaseCharset());
    }

    @Override
    protected void reset() {
        super.reset();
        if (this.m_Reader != null) {
            this.m_Reader.reset();
        }
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "reader", this.m_Reader);
    }

    @Override
    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    @Override
    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    @Override
    public String encodingTipText() {
        return "The type of encoding to use when reading the file, use empty string for default.";
    }

    public void setReader(AbstractTextReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractTextReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader to use for reading the content of the text file.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        if (this.m_Reader == null) {
            return new Class[]{Unknown.class};
        }
        return new Class[]{this.m_Reader.generates()};
    }

    @Override
    protected String doExecute() {
        String result = null;
        Object fileObj = this.m_InputToken.getPayload();
        File file = fileObj instanceof File ? (File)fileObj : new PlaceholderFile((String)fileObj);
        try {
            if (this.m_Reader.useReader()) {
                this.m_Reader.initialize(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.getAbsolutePath()), this.m_Encoding.charsetValue())));
            } else {
                this.m_Reader.initialize(new FileInputStream(file.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to read text from: " + file, e);
            this.m_Reader.reset();
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Reader != null && this.m_Reader.hasNext();
    }

    @Override
    public Token output() {
        Object obj = this.m_Reader.next();
        Token result = obj != null ? new Token(obj) : null;
        this.m_InputToken = null;
        return result;
    }
}

