/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.management.CharsetHelper;
import adams.gui.application.AbstractPreferencesPanel;
import adams.gui.core.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComboBox;

public class CharsetSettingsPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -5325521437739323748L;
    protected ParameterPanel m_PanelParameters;
    protected JComboBox m_ComboBoxCharsets;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelParameters = new ParameterPanel();
        this.add((Component)this.m_PanelParameters, "North");
        this.m_ComboBoxCharsets = new JComboBox<String>(CharsetHelper.getIDs());
        this.m_PanelParameters.addParameter("_Charset", this.m_ComboBoxCharsets);
        this.load();
    }

    protected void load() {
        CharsetHelper helper = CharsetHelper.getSingleton();
        helper.reload();
        this.m_ComboBoxCharsets.setSelectedItem(helper.getCharset());
    }

    @Override
    public String getTitle() {
        return "Charset";
    }

    @Override
    public boolean requiresWrapper() {
        return true;
    }

    @Override
    public String activate() {
        CharsetHelper helper = CharsetHelper.getSingleton();
        if (this.m_ComboBoxCharsets.getSelectedIndex() > -1) {
            helper.setCharset(CharsetHelper.getIDs()[this.m_ComboBoxCharsets.getSelectedIndex()]);
        } else {
            helper.setCharset("Default");
        }
        boolean result = helper.save();
        if (result) {
            return null;
        }
        return "Failed to save charset setup!";
    }
}

