/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.ClassLocator;
import adams.core.CleanUpHandler;
import adams.db.DatabaseConnectionHandler;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.Child;
import adams.gui.core.BaseFrame;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ChildFrame
extends BaseFrame
implements Child {
    protected static final long serialVersionUID = 8588293938686425618L;
    protected AbstractApplicationFrame m_Parent;
    protected ChildFrame m_Self = this;
    protected boolean m_DisposeCalled;
    protected String m_InitialTitle;
    protected String m_IconName;
    protected boolean m_DisposeWindowListenerAdded;

    public ChildFrame(AbstractApplicationFrame parent, String title) {
        this(parent, title, null);
    }

    public ChildFrame(AbstractApplicationFrame parent, String title, String icon) {
        super(title);
        this.m_Parent = parent;
        this.m_InitialTitle = title;
        this.m_DisposeWindowListenerAdded = false;
        this.m_IconName = icon;
        this.performInitialization();
    }

    @Override
    protected void performInitialization() {
        if (this.getParentFrame() != null) {
            super.performInitialization();
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DisposeCalled = false;
    }

    @Override
    protected void initGUI() {
        ImageIcon icon;
        super.initGUI();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                if (ChildFrame.this.getParentFrame() != null) {
                    ChildFrame.this.getParentFrame().createTitle(ChildFrame.this.getTitle());
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                ChildFrame.this.cleanUp();
                if (!ChildFrame.this.m_DisposeCalled && ChildFrame.this.getDefaultCloseOperation() == 2) {
                    ChildFrame.this.dispose();
                }
            }
        });
        if (this.getParentFrame() != null) {
            this.setIconImage(this.getParentFrame().getIconImage());
        }
        if (this.m_IconName != null && (icon = this.m_IconName.indexOf("/") > -1 ? GUIHelper.getExternalIcon(this.m_IconName) : GUIHelper.getIcon(this.m_IconName)) != null) {
            this.setIconImage(icon.getImage());
        }
        if (this.getParentFrame() != null) {
            this.getParentFrame().addChildFrame(this);
        }
    }

    @Override
    public AbstractApplicationFrame getParentFrame() {
        return this.m_Parent;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        if (this.getParentFrame() != null) {
            if (this.isActive()) {
                this.getParentFrame().createTitle(title);
            }
            this.getParentFrame().windowListChanged();
        }
    }

    @Override
    public void cleanUp() {
        Component comp;
        if (this.getContentPane().getComponentCount() > 0 && (comp = this.getContentPane().getComponent(0)) instanceof CleanUpHandler) {
            ((CleanUpHandler)((Object)comp)).cleanUp();
        }
    }

    @Override
    public void dispose() {
        this.m_DisposeCalled = true;
        if (this.getParentFrame() != null) {
            this.getParentFrame().removeChildFrame(this);
            this.getParentFrame().createTitle("");
        }
        super.dispose();
    }

    @Override
    public boolean canCreateNewWindow() {
        Component comp = this.getContentPane().getComponent(0);
        boolean result = ClassLocator.isSubclass(JPanel.class, comp.getClass());
        if (result) {
            try {
                comp.getClass().getConstructor(new Class[0]);
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    @Override
    public ChildFrame getNewWindow() {
        ChildFrame result;
        if (!this.canCreateNewWindow()) {
            return null;
        }
        Component comp = this.getContentPane().getComponent(0);
        try {
            JPanel panel = (JPanel)comp.getClass().newInstance();
            result = new ChildFrame(this.getParentFrame(), this.m_InitialTitle, this.m_IconName);
            result.setSize(this.getSize());
            result.setLocation(this.getX() + 20, this.getY() + 20);
            result.getContentPane().setLayout(new BorderLayout());
            result.getContentPane().add((Component)panel, "Center");
            if (panel instanceof MenuBarProvider) {
                result.setJMenuBar(((MenuBarProvider)((Object)panel)).getMenuBar());
            }
            if (this.getParentFrame() instanceof DatabaseConnectionHandler && panel instanceof DatabaseConnectionHandler) {
                ((DatabaseConnectionHandler)((Object)panel)).setDatabaseConnection(this.getParentFrame().getDatabaseConnection());
            }
            if (this.m_DisposeWindowListenerAdded) {
                result.addDisposeWindowListener();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    @Override
    public void addDisposeWindowListener() {
        this.m_DisposeWindowListenerAdded = true;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ChildFrame.this.m_Self.dispose();
            }
        });
    }

    @Override
    public Logger getLogger() {
        if (this.getParentFrame() != null) {
            return this.getParentFrame().getLogger();
        }
        return this.getLogger();
    }
}

