/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.gui.chooser.FileChooserBookmarksPanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class BaseFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -5712455182900852653L;
    protected boolean m_PromptOverwriteFile;
    protected boolean m_AutoAppendExtension;
    protected boolean m_AllowGlobFilters;
    protected String m_DefaultExtension;
    protected FileChooserBookmarksPanel m_PanelBookmarks;

    public BaseFileChooser() {
        this.initialize();
    }

    public BaseFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.initialize();
    }

    public BaseFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.initialize();
    }

    protected void initialize() {
        this.m_PromptOverwriteFile = true;
        this.m_AutoAppendExtension = false;
        this.m_AllowGlobFilters = true;
        this.m_DefaultExtension = null;
        JComponent accessory = this.createAccessoryPanel();
        if (accessory != null) {
            this.setAccessory(accessory);
        }
        int width = GUIHelper.getInteger("BaseFileChooser.Width", 750);
        int height = GUIHelper.getInteger("BaseFileChooser.Height", 500);
        if (width != -1 && height != -1) {
            this.setPreferredSize(new Dimension(width, height));
        }
    }

    protected Dimension getDefaultAccessoryDimension() {
        int width = GUIHelper.getInteger("BaseFileChooser.Accessory.Width", -1);
        int height = GUIHelper.getInteger("BaseFileChooser.Accessory.Height", -1);
        if (width != -1 && height != -1) {
            return new Dimension(width, height);
        }
        return null;
    }

    protected JComponent createAccessoryPanel() {
        this.m_PanelBookmarks = new FileChooserBookmarksPanel();
        this.m_PanelBookmarks.setOwner(this);
        this.m_PanelBookmarks.setBorder(BorderFactory.createEmptyBorder(2, 5, 0, 0));
        Dimension dim = this.getDefaultAccessoryDimension();
        if (dim != null) {
            this.m_PanelBookmarks.setSize(dim);
            this.m_PanelBookmarks.setMinimumSize(dim);
            this.m_PanelBookmarks.setPreferredSize(dim);
        }
        return this.m_PanelBookmarks;
    }

    public void setPromptOverwriteFile(boolean value) {
        this.m_PromptOverwriteFile = value;
    }

    public boolean getPromptOverwriteFile() {
        return this.m_PromptOverwriteFile;
    }

    public void setAutoAppendExtension(boolean value) {
        this.m_AutoAppendExtension = value;
    }

    public boolean getAutoAppendExtension() {
        return this.m_AutoAppendExtension;
    }

    public void setDefaultExtension(String value) {
        this.m_DefaultExtension = value;
    }

    public String getDefaultExtension() {
        return this.m_DefaultExtension;
    }

    public void setAllowGlobFilters(boolean value) {
        this.m_AllowGlobFilters = value;
    }

    public boolean getAllowGlobFilters() {
        return this.m_AllowGlobFilters;
    }

    protected boolean isGlobFilter(FileFilter filter) {
        if (filter == null) {
            return false;
        }
        return filter.getClass().getName().endsWith("$GlobFilter");
    }

    protected boolean checkFilter(FileFilter filter) {
        boolean result;
        if (filter == null) {
            return true;
        }
        boolean bl = result = filter instanceof ExtensionFileFilter || filter == this.getAcceptAllFileFilter() || this.isGlobFilter(filter) && this.getAllowGlobFilters();
        if (!result) {
            if (this.isGlobFilter(filter)) {
                System.err.println("Please select a filter from the drop-down list!");
            } else {
                System.err.println("Only instances of " + ExtensionFileFilter.class.getName() + " are accepted!\n" + "Provided: " + filter.getClass().getName());
            }
        }
        return result;
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        if (this.checkFilter(filter)) {
            super.setFileFilter(filter);
        }
    }

    @Override
    public void addChoosableFileFilter(FileFilter filter) {
        if (this.checkFilter(filter)) {
            super.addChoosableFileFilter(filter);
        }
    }

    @Override
    public void setSelectedFile(File file) {
        File selFile = null;
        if (file != null) {
            selFile = new File(file.getAbsolutePath());
        }
        if (selFile == null) {
            return;
        }
        try {
            super.setSelectedFile(selFile);
        }
        catch (Exception e) {
            super.setSelectedFile(selFile);
        }
    }

    public PlaceholderFile getSelectedPlaceholderFile() {
        File file = super.getSelectedFile();
        if (file != null) {
            return new PlaceholderFile(file);
        }
        return null;
    }

    @Override
    public void setSelectedFiles(File[] selectedFiles) {
        File[] files = null;
        if (selectedFiles != null) {
            files = new File[selectedFiles.length];
            for (int i = 0; i < selectedFiles.length; ++i) {
                files[i] = selectedFiles[i].getAbsoluteFile();
            }
        }
        try {
            super.setSelectedFiles(files);
        }
        catch (Exception e) {
            super.setSelectedFiles(files);
        }
    }

    @Override
    public File[] getSelectedFiles() {
        File[] result = super.getSelectedFiles();
        if (result.length == 0 && this.getSelectedFile() != null) {
            result = new File[]{this.getSelectedFile()};
        }
        return result;
    }

    public PlaceholderFile[] getSelectedPlaceholderFiles() {
        File[] files = this.getSelectedFiles();
        PlaceholderFile[] result = new PlaceholderFile[files.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new PlaceholderFile(files[i]);
        }
        return result;
    }

    protected boolean hasCorrectExtension(File file, String[] extensions) {
        boolean result = false;
        if (this.getDialogType() == 0) {
            result = file.exists();
        }
        if (this.getDialogType() == 1 && this.getFileFilter() == this.getAcceptAllFileFilter()) {
            result = true;
        }
        if (this.getDialogType() == 1 && this.isGlobFilter(this.getFileFilter())) {
            result = true;
        }
        if (!result) {
            String filename = file.getAbsolutePath().toLowerCase();
            for (int i = 0; i < extensions.length; ++i) {
                if (!filename.endsWith("." + extensions[i].toLowerCase())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) {
        String[] extensions;
        this.m_PanelBookmarks.reload();
        parent = GUIHelper.getParentComponent(parent);
        int result = super.showDialog(parent, approveButtonText);
        if (this.m_AutoAppendExtension && (extensions = this.getFileFilter() != this.getAcceptAllFileFilter() && !this.isGlobFilter(this.getFileFilter()) ? ((ExtensionFileFilter)this.getFileFilter()).getExtensions() : new String[]{this.getDefaultExtension()}) != null) {
            if (this.isMultiSelectionEnabled()) {
                File[] selfiles = this.getSelectedFiles();
                for (int i = 0; i < selfiles.length; ++i) {
                    if (this.hasCorrectExtension(selfiles[i], extensions)) continue;
                    selfiles[i] = new File(selfiles[i].getAbsolutePath() + "." + extensions[0]);
                }
                this.setSelectedFiles(selfiles);
            } else {
                File selfile = this.getSelectedFile();
                if (selfile != null) {
                    if (!this.hasCorrectExtension(selfile, extensions)) {
                        selfile = new File(selfile.getAbsolutePath() + "." + extensions[0]);
                    }
                    this.setSelectedFile(selfile);
                }
            }
        }
        if (result == 0 && this.getDialogType() == 1 && (this.getFileSelectionMode() == 2 || this.getFileSelectionMode() == 0) && this.getPromptOverwriteFile() && this.getSelectedFile() != null && this.getSelectedFile().exists() && !this.getSelectedFile().isDirectory()) {
            int retVal = GUIHelper.showConfirmMessage(parent, "File already exists - overwrite?\n" + this.getSelectedFile(), "File exists already");
            switch (retVal) {
                case 0: {
                    break;
                }
                case 1: {
                    result = this.showSaveDialog(parent);
                    break;
                }
                case 2: {
                    result = 1;
                }
            }
        }
        return result;
    }

    public PlaceholderDirectory getCurrentPlaceholderDirectory() {
        File current = super.getCurrentDirectory();
        if (current == null) {
            return null;
        }
        return new PlaceholderDirectory(current);
    }

    @Override
    public void setCurrentDirectory(File dir) {
        try {
            if (dir == null) {
                super.setCurrentDirectory(null);
            } else {
                super.setCurrentDirectory(dir.getAbsoluteFile());
            }
        }
        catch (Exception e) {
            if (dir == null) {
                super.setCurrentDirectory(null);
            }
            super.setCurrentDirectory(dir.getAbsoluteFile());
        }
    }
}

