/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.DateUtils;
import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.gui.chooser.DateProvider;
import adams.gui.core.BasePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdatepicker.DateModel;
import org.jdatepicker.JDatePanel;
import org.jdatepicker.graphics.JNextIcon;
import org.jdatepicker.graphics.JPreviousIcon;
import org.jdatepicker.impl.UtilCalendarModel;
import org.jdatepicker.util.JDatePickerUtil;

@MixedCopyright(author="Juan Heyns, JC Oosthuizen, Yue Huang", license=License.BSD2, note="fixed some of the colors, setting of enabled state, removed 'clear' button")
public class DatePanel
extends BasePanel
implements JDatePanel,
DateProvider {
    protected static final long serialVersionUID = -2299249311312882915L;
    protected HashSet<ActionListener> actionListeners;
    protected Properties i18nStrings;
    protected boolean showYearButtons;
    protected boolean doubleClickAction;
    protected InternalCalendarModel internalModel;
    protected InternalView internalView;
    protected InternalController internalController;

    @Override
    protected void initialize() {
        super.initialize();
        this.showYearButtons = false;
        this.doubleClickAction = false;
        this.actionListeners = new HashSet();
        this.i18nStrings = new Properties(this.getDefaultStrings());
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.internalModel = new InternalCalendarModel(this.createDefaultDateModel());
        this.internalController = new InternalController();
        this.internalView = new InternalView();
        this.setLayout(new GridLayout(1, 1));
        this.add(this.internalView);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.setDate(new Date());
    }

    protected DateModel<?> createDefaultDateModel() {
        return new UtilCalendarModel();
    }

    protected Properties getDefaultStrings() {
        Properties defaults = new Properties();
        defaults.put("messages.today", "Today");
        defaults.put("messages.nextMonth", "Next month");
        defaults.put("messages.previousMonth", "Previous month");
        defaults.put("messages.nextYear", "Next year");
        defaults.put("messages.previousYear", "Previous year");
        defaults.put("messages.clear", "Clear");
        return defaults;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    protected void fireActionPerformed() {
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(new ActionEvent(this, 1001, "Date selected"));
        }
    }

    public void setI18nStrings(Properties i18nStrings) {
        this.i18nStrings = i18nStrings;
    }

    public Properties getI18nStrings() {
        return this.i18nStrings;
    }

    public void setShowYearButtons(boolean showYearButtons) {
        this.showYearButtons = showYearButtons;
        this.internalView.updateShowYearButtons();
    }

    public boolean isShowYearButtons() {
        return this.showYearButtons;
    }

    public void setDoubleClickAction(boolean doubleClickAction) {
        this.doubleClickAction = doubleClickAction;
    }

    public boolean isDoubleClickAction() {
        return this.doubleClickAction;
    }

    public DateModel<?> getModel() {
        return this.internalModel.getModel();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.internalView.setEnabled(b);
    }

    @Override
    public void setDate(Date value) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(value);
        ((UtilCalendarModel)this.internalModel.getModel()).setValue((Object)cal);
    }

    @Override
    public Date getDate() {
        return ((Calendar)((UtilCalendarModel)this.internalModel.getModel()).getValue()).getTime();
    }

    protected class InternalCalendarModel
    implements TableModel,
    SpinnerModel,
    ChangeListener {
        protected DateModel<?> model;
        protected HashSet<ChangeListener> spinnerChangeListeners = new HashSet();
        protected HashSet<TableModelListener> tableModelListeners = new HashSet();

        public InternalCalendarModel(DateModel<?> model) {
            this.model = model;
            model.addChangeListener((ChangeListener)this);
        }

        public DateModel<?> getModel() {
            return this.model;
        }

        @Override
        public void addChangeListener(ChangeListener arg0) {
            this.spinnerChangeListeners.add(arg0);
        }

        @Override
        public void removeChangeListener(ChangeListener arg0) {
            this.spinnerChangeListeners.remove(arg0);
        }

        @Override
        public Object getNextValue() {
            return Integer.toString(this.model.getYear() + 1);
        }

        @Override
        public Object getPreviousValue() {
            return Integer.toString(this.model.getYear() - 1);
        }

        @Override
        public void setValue(Object text) {
            this.model.setYear(new Integer((String)text).intValue());
        }

        @Override
        public Object getValue() {
            return Integer.toString(this.model.getYear());
        }

        @Override
        public void addTableModelListener(TableModelListener arg0) {
            this.tableModelListeners.add(arg0);
        }

        @Override
        public void removeTableModelListener(TableModelListener arg0) {
            this.tableModelListeners.remove(arg0);
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int arg0) {
            DateFormatSymbols df = new DateFormatSymbols();
            String[] shortDays = df.getShortWeekdays();
            return shortDays[arg0 + 1];
        }

        public Class getColumnClass(int arg0) {
            return Integer.class;
        }

        @Override
        public int getRowCount() {
            return 6;
        }

        @Override
        public Object getValueAt(int arg0, int arg1) {
            Calendar firstDayOfMonth = Calendar.getInstance();
            firstDayOfMonth.set(this.model.getYear(), this.model.getMonth(), 1);
            int DOW = firstDayOfMonth.get(7);
            int value = arg1 - DOW + arg0 * 7 + 2;
            return new Integer(value);
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }

        @Override
        public void setValueAt(Object arg0, int arg1, int arg2) {
        }

        protected void fireValueChanged() {
            for (ChangeListener cl : this.spinnerChangeListeners) {
                cl.stateChanged(new ChangeEvent(this));
            }
            DatePanel.this.internalView.updateMonthLabel();
            for (TableModelListener tl : this.tableModelListeners) {
                tl.tableChanged(new TableModelEvent(this));
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireValueChanged();
        }
    }

    protected class InternalController
    implements ActionListener,
    MouseListener {
        protected InternalController() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getSource() == DatePanel.this.internalView.getNextMonthButton()) {
                DatePanel.this.internalModel.getModel().addMonth(1);
            } else if (arg0.getSource() == DatePanel.this.internalView.getPreviousMonthButton()) {
                DatePanel.this.internalModel.getModel().addMonth(-1);
            } else if (arg0.getSource() == DatePanel.this.internalView.getNextYearButton()) {
                DatePanel.this.internalModel.getModel().addYear(1);
            } else if (arg0.getSource() == DatePanel.this.internalView.getPreviousYearButton()) {
                DatePanel.this.internalModel.getModel().addYear(-1);
            } else {
                for (int month = 0; month < DatePanel.this.internalView.getMonthPopupMenuItems().length; ++month) {
                    if (arg0.getSource() != DatePanel.this.internalView.getMonthPopupMenuItems()[month]) continue;
                    DatePanel.this.internalModel.getModel().setMonth(month);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.getSource() == DatePanel.this.internalView.getMonthLabel()) {
                DatePanel.this.internalView.getMonthPopupMenu().setLightWeightPopupEnabled(false);
                DatePanel.this.internalView.getMonthPopupMenu().show((Component)arg0.getSource(), arg0.getX(), arg0.getY());
            } else if (arg0.getSource() == DatePanel.this.internalView.getTodayLabel()) {
                Calendar today = Calendar.getInstance();
                DatePanel.this.internalModel.getModel().setDate(today.get(1), today.get(2), today.get(5));
            } else if (arg0.getSource() == DatePanel.this.internalView.getDayTable()) {
                int row = DatePanel.this.internalView.getDayTable().getSelectedRow();
                int col = DatePanel.this.internalView.getDayTable().getSelectedColumn();
                if (row >= 0 && row <= 5) {
                    Integer date = (Integer)DatePanel.this.internalModel.getValueAt(row, col);
                    DatePanel.this.internalModel.getModel().setDay(date.intValue());
                    DatePanel.this.internalModel.getModel().setSelected(true);
                    if (DatePanel.this.doubleClickAction && arg0.getClickCount() == 2) {
                        DatePanel.this.fireActionPerformed();
                    }
                    if (!DatePanel.this.doubleClickAction) {
                        DatePanel.this.fireActionPerformed();
                    }
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }

    protected class InternalTableCellRenderer
    extends DefaultTableCellRenderer {
        protected static final long serialVersionUID = -2341614459632756921L;

        protected InternalTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean isSelected, boolean hasFocus, int row, int col) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(arg0, arg1, isSelected, hasFocus, row, col);
            label.setHorizontalAlignment(0);
            if (row == -1) {
                label.setForeground(new Color(10, 36, 106));
                label.setBackground(Color.LIGHT_GRAY);
                label.setHorizontalAlignment(0);
                return label;
            }
            Calendar todayCal = Calendar.getInstance();
            Calendar selectedCal = Calendar.getInstance();
            selectedCal.set(DatePanel.this.internalModel.getModel().getYear(), DatePanel.this.internalModel.getModel().getMonth(), DatePanel.this.internalModel.getModel().getDay());
            int cellDayValue = (Integer)arg1;
            int lastDayOfMonth = selectedCal.getActualMaximum(5);
            if (cellDayValue < 1 || cellDayValue > lastDayOfMonth) {
                label.setForeground(Color.LIGHT_GRAY);
                label.setBackground(Color.WHITE);
                if (cellDayValue > lastDayOfMonth) {
                    label.setText(Integer.toString(cellDayValue - lastDayOfMonth));
                } else {
                    Calendar lastMonth = DateUtils.getCalendar();
                    lastMonth.set(selectedCal.get(1), selectedCal.get(2) - 1, 1);
                    int lastDayLastMonth = lastMonth.getActualMaximum(5);
                    label.setText(Integer.toString(lastDayLastMonth + cellDayValue));
                }
            } else {
                label.setForeground(Color.BLACK);
                label.setBackground(Color.WHITE);
                if (todayCal.get(5) == cellDayValue && todayCal.get(2) == DatePanel.this.internalModel.getModel().getMonth() && todayCal.get(1) == DatePanel.this.internalModel.getModel().getYear()) {
                    label.setForeground(Color.RED);
                    if (DatePanel.this.internalModel.getModel().isSelected() && selectedCal.get(5) == cellDayValue) {
                        label.setBackground(new Color(10, 36, 106));
                    }
                } else if (DatePanel.this.internalModel.getModel().isSelected() && selectedCal.get(5) == cellDayValue) {
                    label.setForeground(Color.WHITE);
                    label.setBackground(new Color(10, 36, 106));
                }
            }
            return label;
        }
    }

    protected class InternalView
    extends JPanel {
        protected static final long serialVersionUID = -6844493839307157682L;
        protected JPanel centerPanel;
        protected JPanel northCenterPanel;
        protected JPanel northPanel;
        protected JPanel southPanel;
        protected JPanel previousButtonPanel;
        protected JPanel nextButtonPanel;
        protected JTable dayTable;
        protected JTableHeader dayTableHeader;
        protected InternalTableCellRenderer dayTableCellRenderer;
        protected JLabel monthLabel;
        protected JLabel todayLabel;
        protected JLabel noneLabel;
        protected JPopupMenu monthPopupMenu;
        protected JMenuItem[] monthPopupMenuItems;
        protected JButton nextMonthButton;
        protected JButton previousMonthButton;
        protected JButton previousYearButton;
        protected JButton nextYearButton;
        protected JSpinner yearSpinner;

        protected void updateShowYearButtons() {
            if (DatePanel.this.showYearButtons) {
                this.getNextButtonPanel().add(this.getNextYearButton());
                this.getPreviousButtonPanel().removeAll();
                this.getPreviousButtonPanel().add(this.getPreviousYearButton());
                this.getPreviousButtonPanel().add(this.getPreviousMonthButton());
            } else {
                this.getNextButtonPanel().remove(this.getNextYearButton());
                this.getPreviousButtonPanel().remove(this.getPreviousYearButton());
            }
        }

        protected void updateMonthLabel() {
            DateFormatSymbols df = new DateFormatSymbols();
            this.monthLabel.setText(df.getMonths()[DatePanel.this.internalModel.getModel().getMonth()]);
        }

        public InternalView() {
            this.initialise();
        }

        protected void initialise() {
            this.setLayout(new BorderLayout());
            this.setSize(200, 180);
            this.setPreferredSize(new Dimension(200, 180));
            this.setBackground(SystemColor.activeCaptionText);
            this.setOpaque(false);
            this.add((Component)this.getNorthPanel(), "North");
            this.add((Component)this.getSouthPanel(), "South");
            this.add((Component)this.getCenterPanel(), "Center");
        }

        protected JPanel getNorthPanel() {
            if (this.northPanel == null) {
                this.northPanel = new JPanel();
                this.northPanel.setLayout(new BorderLayout());
                this.northPanel.setName("");
                this.northPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                this.northPanel.add((Component)this.getPreviousButtonPanel(), "West");
                this.northPanel.add((Component)this.getNextButtonPanel(), "East");
                this.northPanel.add((Component)this.getNorthCenterPanel(), "Center");
            }
            return this.northPanel;
        }

        protected JPanel getNorthCenterPanel() {
            if (this.northCenterPanel == null) {
                this.northCenterPanel = new JPanel();
                this.northCenterPanel.setLayout(new BorderLayout());
                this.northCenterPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                this.northCenterPanel.add((Component)this.getMonthLabel(), "Center");
                this.northCenterPanel.add((Component)this.getYearSpinner(), "East");
            }
            return this.northCenterPanel;
        }

        protected JLabel getMonthLabel() {
            if (this.monthLabel == null) {
                this.monthLabel = new JLabel();
                this.monthLabel.setHorizontalAlignment(0);
                this.monthLabel.addMouseListener(DatePanel.this.internalController);
                this.updateMonthLabel();
            }
            return this.monthLabel;
        }

        protected JSpinner getYearSpinner() {
            if (this.yearSpinner == null) {
                this.yearSpinner = new JSpinner();
                this.yearSpinner.setModel(DatePanel.this.internalModel);
            }
            return this.yearSpinner;
        }

        protected JPanel getSouthPanel() {
            if (this.southPanel == null) {
                this.southPanel = new JPanel();
                this.southPanel.setLayout(new BorderLayout());
                this.southPanel.setBackground(Color.WHITE);
                this.southPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                this.southPanel.add((Component)this.getTodayLabel(), "West");
            }
            return this.southPanel;
        }

        protected JLabel getTodayLabel() {
            if (this.todayLabel == null) {
                this.todayLabel = new JLabel();
                this.todayLabel.setHorizontalAlignment(0);
                this.todayLabel.addMouseListener(DatePanel.this.internalController);
                DateFormat df1 = JDatePickerUtil.getMediumDateFormat();
                this.todayLabel.setText(DatePanel.this.i18nStrings.getProperty("messages.today") + ": " + df1.format(new Date()));
            }
            return this.todayLabel;
        }

        protected JPanel getCenterPanel() {
            if (this.centerPanel == null) {
                this.centerPanel = new JPanel();
                this.centerPanel.setLayout(new BorderLayout());
                this.centerPanel.setOpaque(false);
                this.centerPanel.add((Component)this.getDayTableHeader(), "North");
                this.centerPanel.add((Component)this.getDayTable(), "Center");
            }
            return this.centerPanel;
        }

        protected JTable getDayTable() {
            if (this.dayTable == null) {
                this.dayTable = new JTable();
                this.dayTable.setAutoResizeMode(4);
                this.dayTable.setRowHeight(18);
                this.dayTable.setPreferredSize(new Dimension(100, 80));
                this.dayTable.setModel(DatePanel.this.internalModel);
                this.dayTable.setShowGrid(true);
                this.dayTable.setGridColor(Color.WHITE);
                this.dayTable.setSelectionMode(0);
                this.dayTable.setCellSelectionEnabled(true);
                this.dayTable.setRowSelectionAllowed(true);
                this.dayTable.setFocusable(false);
                this.dayTable.addMouseListener(DatePanel.this.internalController);
                TableColumn column = null;
                for (int i = 0; i < 7; ++i) {
                    column = this.dayTable.getColumnModel().getColumn(i);
                    column.setPreferredWidth(15);
                    column.setCellRenderer(this.getDayTableCellRenderer());
                }
            }
            return this.dayTable;
        }

        protected InternalTableCellRenderer getDayTableCellRenderer() {
            if (this.dayTableCellRenderer == null) {
                this.dayTableCellRenderer = new InternalTableCellRenderer();
            }
            return this.dayTableCellRenderer;
        }

        protected JTableHeader getDayTableHeader() {
            if (this.dayTableHeader == null) {
                this.dayTableHeader = this.getDayTable().getTableHeader();
                this.dayTableHeader.setResizingAllowed(false);
                this.dayTableHeader.setReorderingAllowed(false);
                this.dayTableHeader.setDefaultRenderer(this.getDayTableCellRenderer());
            }
            return this.dayTableHeader;
        }

        protected JPanel getPreviousButtonPanel() {
            if (this.previousButtonPanel == null) {
                this.previousButtonPanel = new JPanel();
                GridLayout layout = new GridLayout(1, 2);
                layout.setHgap(3);
                this.previousButtonPanel.setLayout(layout);
                this.previousButtonPanel.setName("");
                this.previousButtonPanel.setBackground(SystemColor.activeCaption);
                if (DatePanel.this.isShowYearButtons()) {
                    this.previousButtonPanel.add(this.getPreviousYearButton());
                }
                this.previousButtonPanel.add(this.getPreviousMonthButton());
            }
            return this.previousButtonPanel;
        }

        protected JPanel getNextButtonPanel() {
            if (this.nextButtonPanel == null) {
                this.nextButtonPanel = new JPanel();
                GridLayout layout = new GridLayout(1, 2);
                layout.setHgap(3);
                this.nextButtonPanel.setLayout(layout);
                this.nextButtonPanel.setName("");
                this.nextButtonPanel.setBackground(SystemColor.activeCaption);
                this.nextButtonPanel.add(this.getNextMonthButton());
                if (DatePanel.this.isShowYearButtons()) {
                    this.nextButtonPanel.add(this.getNextYearButton());
                }
            }
            return this.nextButtonPanel;
        }

        protected JButton getNextMonthButton() {
            if (this.nextMonthButton == null) {
                this.nextMonthButton = new JButton((Icon)new JNextIcon(4, 7));
                this.nextMonthButton.setText("");
                this.nextMonthButton.setPreferredSize(new Dimension(20, 15));
                this.nextMonthButton.setBorder(BorderFactory.createBevelBorder(0));
                this.nextMonthButton.setFocusable(false);
                this.nextMonthButton.addActionListener(DatePanel.this.internalController);
                this.nextMonthButton.setToolTipText(DatePanel.this.i18nStrings.getProperty("messages.nextMonth"));
            }
            return this.nextMonthButton;
        }

        protected JButton getNextYearButton() {
            if (this.nextYearButton == null) {
                this.nextYearButton = new JButton((Icon)new JNextIcon(8, 7, true));
                this.nextYearButton.setText("");
                this.nextYearButton.setPreferredSize(new Dimension(20, 15));
                this.nextYearButton.setBorder(BorderFactory.createBevelBorder(0));
                this.nextYearButton.setFocusable(false);
                this.nextYearButton.addActionListener(DatePanel.this.internalController);
                this.nextYearButton.setToolTipText(DatePanel.this.i18nStrings.getProperty("messages.nextYear"));
            }
            return this.nextYearButton;
        }

        protected JButton getPreviousMonthButton() {
            if (this.previousMonthButton == null) {
                this.previousMonthButton = new JButton((Icon)new JPreviousIcon(4, 7));
                this.previousMonthButton.setText("");
                this.previousMonthButton.setPreferredSize(new Dimension(20, 15));
                this.previousMonthButton.setBorder(BorderFactory.createBevelBorder(0));
                this.previousMonthButton.setFocusable(false);
                this.previousMonthButton.addActionListener(DatePanel.this.internalController);
                this.previousMonthButton.setToolTipText(DatePanel.this.i18nStrings.getProperty("messages.previousMonth"));
            }
            return this.previousMonthButton;
        }

        protected JButton getPreviousYearButton() {
            if (this.previousYearButton == null) {
                this.previousYearButton = new JButton((Icon)new JPreviousIcon(8, 7, true));
                this.previousYearButton.setText("");
                this.previousYearButton.setPreferredSize(new Dimension(20, 15));
                this.previousYearButton.setBorder(BorderFactory.createBevelBorder(0));
                this.previousYearButton.setFocusable(false);
                this.previousYearButton.addActionListener(DatePanel.this.internalController);
                this.previousYearButton.setToolTipText(DatePanel.this.i18nStrings.getProperty("messages.previousYear"));
            }
            return this.previousYearButton;
        }

        protected JPopupMenu getMonthPopupMenu() {
            if (this.monthPopupMenu == null) {
                this.monthPopupMenu = new JPopupMenu();
                JMenuItem[] menuItems = this.getMonthPopupMenuItems();
                for (int i = 0; i < menuItems.length; ++i) {
                    this.monthPopupMenu.add(menuItems[i]);
                }
            }
            return this.monthPopupMenu;
        }

        protected JMenuItem[] getMonthPopupMenuItems() {
            if (this.monthPopupMenuItems == null) {
                DateFormatSymbols df = new DateFormatSymbols();
                String[] months = df.getMonths();
                this.monthPopupMenuItems = new JMenuItem[months.length - 1];
                for (int i = 0; i < months.length - 1; ++i) {
                    JMenuItem mi = new JMenuItem(months[i]);
                    mi.addActionListener(DatePanel.this.internalController);
                    this.monthPopupMenuItems[i] = mi;
                }
            }
            return this.monthPopupMenuItems;
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            this.dayTable.setEnabled(b);
            this.monthLabel.setEnabled(b);
            this.nextMonthButton.setEnabled(b);
            this.previousMonthButton.setEnabled(b);
            this.yearSpinner.setEnabled(b);
            if (DatePanel.this.isShowYearButtons()) {
                this.nextYearButton.setEnabled(b);
                this.previousYearButton.setEnabled(b);
            }
        }
    }
}

