/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.BaseFrame;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.MouseUtils;
import adams.gui.core.SearchPanel;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import gnu.trove.list.array.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractNamedHistoryPanel<T>
extends BasePanel {
    private static final long serialVersionUID = -6028207793460507677L;
    protected JList m_List;
    protected DefaultListModel m_ListModel;
    protected DefaultListModel m_ListModelFiltered;
    protected Hashtable<String, T> m_Entries;
    protected Hashtable<String, Object> m_Payloads;
    protected PopupCustomizer m_PopupCustomizer;
    protected HashSet<HistoryEntrySelectionListener> m_HistoryEntrySelectionListeners;
    protected SearchPanel m_PanelSearch;
    protected String m_SearchString;
    protected boolean m_SearchRegexp;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Entries = new Hashtable();
        this.m_Payloads = new Hashtable();
        this.m_ListModel = new DefaultListModel();
        this.m_ListModelFiltered = null;
        this.m_PopupCustomizer = null;
        this.m_SearchString = null;
        this.m_SearchRegexp = false;
        this.m_HistoryEntrySelectionListeners = new HashSet();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_List = new JList(this.m_ListModel);
        this.m_List.setSelectionMode(2);
        this.m_List.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    AbstractNamedHistoryPanel.this.showPopup(e);
                    e.consume();
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        this.m_List.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String name = AbstractNamedHistoryPanel.this.getSelectedEntry();
                if (name != null) {
                    AbstractNamedHistoryPanel.this.updateEntry(name);
                }
                AbstractNamedHistoryPanel.this.notifyHistoryEntrySelectionListeners(new HistoryEntrySelectionEvent(AbstractNamedHistoryPanel.this, AbstractNamedHistoryPanel.this.getSelectedEntries()));
            }
        });
        this.add((Component)new BaseScrollPane(this.m_List), "Center");
        this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, false, null, true, "");
        this.m_PanelSearch.setVisible(false);
        this.m_PanelSearch.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                if (!AbstractNamedHistoryPanel.this.getAllowSearch()) {
                    return;
                }
                AbstractNamedHistoryPanel.this.m_SearchString = e.getParameters().getSearchString();
                if (AbstractNamedHistoryPanel.this.m_SearchString.isEmpty()) {
                    AbstractNamedHistoryPanel.this.m_SearchString = null;
                }
                AbstractNamedHistoryPanel.this.m_SearchRegexp = e.getParameters().isRegExp();
                AbstractNamedHistoryPanel.this.updateSearch();
            }
        });
        this.add((Component)this.m_PanelSearch, "South");
    }

    protected void showPopup(MouseEvent e) {
        JPopupMenu menu = this.createPopup(e);
        if (this.m_PopupCustomizer != null) {
            this.m_PopupCustomizer.customizePopup(this.getSelectedEntries(), menu);
        }
        menu.show(this, e.getX(), e.getY());
    }

    protected JPopupMenu createPopup(MouseEvent e) {
        JPopupMenu result = new JPopupMenu();
        final int[] indices = this.getSelectedIndices();
        JMenuItem menuitem = new JMenuItem("Show");
        menuitem.setEnabled(indices.length == 1);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractNamedHistoryPanel.this.updateEntry(AbstractNamedHistoryPanel.this.getEntryName(indices[0]));
            }
        });
        result.add(menuitem);
        if (this instanceof FrameDisplaySupporter) {
            menuitem = new JMenuItem("Show in separate frame");
            menuitem.setEnabled(indices.length == 1);
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((FrameDisplaySupporter)((Object)AbstractNamedHistoryPanel.this)).showFrame(AbstractNamedHistoryPanel.this.getEntryName(indices[0]));
                }
            });
            result.add(menuitem);
        }
        result.addSeparator();
        menuitem = new JMenuItem();
        if (indices.length > 1) {
            menuitem.setText("Remove " + indices.length + " entries");
        } else {
            menuitem.setText("Remove entry");
        }
        menuitem.setEnabled(indices.length >= 1);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = indices.length - 1; i >= 0; --i) {
                    AbstractNamedHistoryPanel.this.removeEntry(AbstractNamedHistoryPanel.this.getEntryName(indices[0]));
                }
            }
        });
        result.add(menuitem);
        menuitem = new JMenuItem("Remove all");
        menuitem.setEnabled(this.m_Entries.size() > 0);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractNamedHistoryPanel.this.clear();
            }
        });
        result.add(menuitem);
        return result;
    }

    protected abstract void updateEntry(String var1);

    protected void updateSearch() {
        if (this.m_SearchString == null) {
            this.m_ListModelFiltered = null;
            this.m_List.setModel(this.m_ListModel);
        } else {
            this.m_ListModelFiltered = new DefaultListModel();
            String search = this.m_SearchRegexp ? this.m_SearchString : this.m_SearchString.toLowerCase();
            for (int i = 0; i < this.m_ListModel.size(); ++i) {
                boolean match;
                String entry = (String)this.m_ListModel.get(i);
                if (this.m_SearchRegexp) {
                    match = entry.matches(search);
                } else {
                    boolean bl = match = entry.toLowerCase().indexOf(search) > -1;
                }
                if (!match) continue;
                this.m_ListModelFiltered.addElement(entry);
            }
            this.m_List.setModel(this.m_ListModelFiltered);
        }
        this.updateEntry(null);
    }

    public boolean hasSearch() {
        return this.m_SearchString != null;
    }

    protected DefaultListModel getListModel() {
        if (this.m_ListModelFiltered != null) {
            return this.m_ListModelFiltered;
        }
        return this.m_ListModel;
    }

    public void clear() {
        this.m_Entries.clear();
        this.m_Payloads.clear();
        this.m_ListModel.clear();
        this.m_ListModelFiltered = null;
        this.updateEntry(null);
    }

    public int count() {
        return this.getListModel().size();
    }

    public Enumeration<String> entries() {
        return this.m_Entries.keys();
    }

    public boolean hasEntry(String name) {
        return this.m_Entries.containsKey(name);
    }

    public boolean hasPayload(String name) {
        return this.m_Payloads.containsKey(name);
    }

    public synchronized String newEntryName(String name) {
        String result = name;
        int count = 1;
        while (this.hasEntry(result)) {
            result = name + " (" + ++count + ")";
        }
        return result;
    }

    public int indexOfEntry(String name) {
        int result = -1;
        if (this.hasEntry(name)) {
            for (int i = 0; i < this.getListModel().size(); ++i) {
                if (!name.equals((String)this.getListModel().get(i))) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public T getEntry(String name) {
        return this.m_Entries.get(name);
    }

    public Object getPayload(String name) {
        return this.m_Payloads.get(name);
    }

    public T getEntry(int index) {
        return this.m_Entries.get((String)this.getListModel().get(index));
    }

    public Object getPayload(int index) {
        return this.m_Payloads.get((String)this.getListModel().get(index));
    }

    public String getEntryName(int index) {
        return (String)this.getListModel().get(index);
    }

    public T addEntry(String name, T entry) {
        return this.addEntry(name, entry, null);
    }

    public T addEntry(String name, T entry, Object payload) {
        T result = this.m_Entries.put(name, entry);
        if (result == null) {
            this.m_ListModel.addElement(name);
        }
        if (payload != null) {
            this.setPayload(name, payload);
        }
        if (this.hasSearch()) {
            this.updateSearch();
        }
        return result;
    }

    public void setPayload(String name, Object payload) {
        if (this.hasEntry(name)) {
            this.m_Payloads.put(name, payload);
        }
    }

    public void insertEntryAt(String name, T entry, int index) {
        this.insertEntryAt(name, entry, null, index);
    }

    public void insertEntryAt(String name, T entry, Object payload, int index) {
        int oldIndex = this.indexOfEntry(name);
        this.m_Entries.put(name, entry);
        this.m_ListModel.insertElementAt(name, index);
        if (oldIndex > -1) {
            if (oldIndex < index) {
                this.m_ListModel.remove(oldIndex);
            } else {
                this.m_ListModel.remove(oldIndex - 1);
            }
        }
        if (payload != null) {
            this.setPayload(name, payload);
        }
        if (this.hasSearch()) {
            this.updateSearch();
        }
    }

    public T removeEntry(String name) {
        int index = this.indexOfEntry(name);
        if (index > -1) {
            this.m_ListModel.remove(index);
        }
        this.m_Payloads.remove(name);
        this.updateEntry(null);
        if (this.hasSearch()) {
            this.updateSearch();
        }
        return this.m_Entries.remove(name);
    }

    public Object removePayload(String name) {
        return this.m_Payloads.remove(name);
    }

    public void setSelectedIndex(int value) {
        this.m_List.setSelectedIndex(value);
    }

    public synchronized String renameEntry(String oldName, String newName) {
        if (!this.hasEntry(oldName)) {
            return "'" + oldName + "' does not exist!";
        }
        if (this.hasEntry(newName)) {
            return "'" + newName + "' already exists!";
        }
        int index = this.indexOfEntry(oldName);
        this.m_Entries.put(newName, this.m_Entries.remove(oldName));
        this.m_ListModel.set(index, newName);
        if (this.hasSearch()) {
            this.updateSearch();
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.m_List.getSelectedIndex();
    }

    public void setSelectedIndices(int[] value) {
        this.m_List.setSelectedIndices(value);
    }

    public int[] getSelectedIndices() {
        return this.m_List.getSelectedIndices();
    }

    public void setSelectedEntry(String value) {
        this.setSelectedEntries(new String[]{value});
    }

    public String getSelectedEntry() {
        String[] entries = this.getSelectedEntries();
        if (entries.length > 0) {
            return entries[0];
        }
        return null;
    }

    public void setSelectedEntries(String[] value) {
        TIntArrayList list = new TIntArrayList();
        for (int i = 0; i < value.length; ++i) {
            int index = this.indexOfEntry(value[i]);
            if (index <= -1) continue;
            list.add(index);
        }
        this.setSelectedIndices(list.toArray());
    }

    public String[] getSelectedEntries() {
        int[] indices = this.getSelectedIndices();
        String[] result = new String[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            result[i] = (String)this.getListModel().get(indices[i]);
        }
        return result;
    }

    public void setPopupCustomizer(PopupCustomizer value) {
        this.m_PopupCustomizer = value;
    }

    public PopupCustomizer getPopupCustomizer() {
        return this.m_PopupCustomizer;
    }

    public void addHistoryEntrySelectionListener(HistoryEntrySelectionListener l) {
        this.m_HistoryEntrySelectionListeners.add(l);
    }

    public void removeHistoryEntrySelectionListener(HistoryEntrySelectionListener l) {
        this.m_HistoryEntrySelectionListeners.remove(l);
    }

    protected void notifyHistoryEntrySelectionListeners(HistoryEntrySelectionEvent e) {
        for (HistoryEntrySelectionListener l : this.m_HistoryEntrySelectionListeners) {
            l.historyEntrySelected(e);
        }
    }

    public void setAllowSearch(boolean value) {
        this.m_PanelSearch.setVisible(value);
    }

    public boolean getAllowSearch() {
        return this.m_PanelSearch.isVisible();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        Dimension list = this.m_List.getPreferredSize();
        if (list.width > result.width) {
            result.width = list.width;
        }
        if (this.getAllowSearch()) {
            Dimension search = this.m_PanelSearch.getPreferredSize();
            if (search.width > result.width) {
                result.width = search.width;
            }
        }
        return result;
    }

    public static abstract class AbstractHistoryEntryFrame<T>
    extends BaseFrame {
        private static final long serialVersionUID = 2552148773749071235L;
        protected AbstractNamedHistoryPanel<T> m_EntryOwner;
        protected String m_EntryName;

        public AbstractHistoryEntryFrame(AbstractNamedHistoryPanel<T> owner, String name) {
            super("Result - " + name);
            if (!(owner instanceof FrameDisplaySupporter)) {
                throw new IllegalArgumentException("History panel must implement " + FrameDisplaySupporter.class.getName());
            }
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ((FrameDisplaySupporter)((Object)AbstractHistoryEntryFrame.this.getEntryOwner())).removeFrame(AbstractHistoryEntryFrame.this.getEntryName());
                }
            });
            this.m_EntryOwner = owner;
            this.m_EntryName = name;
            this.updateEntry();
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setDefaultCloseOperation(2);
            this.setSize(this.getDefaultSize());
        }

        protected Dimension getDefaultSize() {
            return new Dimension(640, 480);
        }

        public AbstractNamedHistoryPanel<T> getEntryOwner() {
            return this.m_EntryOwner;
        }

        public String getEntryName() {
            return this.m_EntryName;
        }

        public abstract void updateEntry();
    }

    public static interface FrameDisplaySupporter<T> {
        public boolean hasFrame(String var1);

        public AbstractHistoryEntryFrame<T> newFrame(String var1);

        public AbstractHistoryEntryFrame<T> getFrame(String var1);

        public void showFrame(String var1);

        public void removeFrame(String var1);
    }

    public static interface HistoryEntrySelectionListener {
        public void historyEntrySelected(HistoryEntrySelectionEvent var1);
    }

    public static class HistoryEntrySelectionEvent
    extends EventObject {
        private static final long serialVersionUID = 6402304240357916438L;
        protected String[] m_Names;

        public HistoryEntrySelectionEvent(AbstractNamedHistoryPanel source, String[] names) {
            super(source);
            this.m_Names = (String[])names.clone();
        }

        public AbstractNamedHistoryPanel getPanel() {
            return (AbstractNamedHistoryPanel)this.getSource();
        }

        public String[] getNames() {
            return this.m_Names;
        }
    }

    public static interface PopupCustomizer {
        public void customizePopup(String[] var1, JPopupMenu var2);
    }
}

