/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.Properties;
import adams.core.management.OS;
import adams.env.Environment;
import adams.gui.core.GUIHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.net.URI;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.codehaus.plexus.util.FileUtils;

public class BrowserHelper {
    public static final String FILENAME = "Browser.props";
    protected static Properties m_Properties;

    public static synchronized String openURL(String url) {
        return BrowserHelper.openURL(null, url);
    }

    public static synchronized String openURL(Component parent, String url) {
        return BrowserHelper.openURL(parent, url, true);
    }

    public static synchronized String openURL(Component parent, String url, boolean showDialog) {
        String result = null;
        try {
            String defBrowser = BrowserHelper.getProperties().getPath("DefaultBrowser", "");
            if (defBrowser.trim().length() > 0 && FileUtils.fileExists((String)defBrowser)) {
                Runtime.getRuntime().exec(new String[]{defBrowser, url});
            } else if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(new URI(url));
            } else {
                System.err.println("Desktop or browse action not supported, using fallback to determine browser.");
                if (OS.isMac()) {
                    Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                    Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                    openURL.invoke(null, url);
                } else if (OS.isWindows()) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else {
                    String browser = null;
                    String[] browsers = BrowserHelper.getProperties().getProperty("LinuxBrowsers", "firefox").replaceAll(" ", "").split(",");
                    for (int count = 0; count < browsers.length && browser == null; ++count) {
                        if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                        browser = browsers[count];
                        break;
                    }
                    if (browser == null) {
                        throw new Exception("Could not find web browser");
                    }
                    Runtime.getRuntime().exec(new String[]{browser, url});
                }
            }
        }
        catch (Exception e) {
            result = "Error attempting to launch web browser:\n" + e.getMessage();
            if (showDialog) {
                GUIHelper.showErrorMessage(parent, result);
            }
            System.err.println(result);
        }
        return result;
    }

    public static synchronized String openURL(Component parent, String cmd, String url, boolean showDialog) {
        String result = null;
        try {
            Runtime.getRuntime().exec(cmd + " " + url);
        }
        catch (Exception e) {
            result = "Error attempting to launch web browser '" + cmd + "':\n" + e.getMessage();
            if (showDialog) {
                GUIHelper.showErrorMessage(parent, result);
            }
            System.err.println(result);
        }
        return result;
    }

    public static JLabel createLink(String url, String text) {
        final String urlF = url;
        final JLabel result = new JLabel();
        result.setText(text == null || text.length() == 0 ? url : text);
        result.setToolTipText("Click to open link in browser");
        result.setForeground(Color.BLUE);
        result.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    BrowserHelper.openURL(urlF);
                } else {
                    super.mouseClicked(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                result.setForeground(Color.RED);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                result.setForeground(Color.BLUE);
            }
        });
        return result;
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("browser");
        }
        return m_Properties;
    }

    public static class DefaultHyperlinkListener
    implements HyperlinkListener {
        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e instanceof HTMLFrameHyperlinkEvent) {
                if (e.getSource() instanceof JEditorPane) {
                    JEditorPane editor = (JEditorPane)e.getSource();
                    HTMLDocument doc = (HTMLDocument)editor.getDocument();
                    doc.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                }
            } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    BrowserHelper.openURL(e.getURL().toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

