/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.io.FileUtils;
import adams.gui.chooser.TextFileChooser;
import adams.gui.core.AbstractNamedHistoryPanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Hashtable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

public class BufferHistoryPanel
extends AbstractNamedHistoryPanel<StringBuilder>
implements AbstractNamedHistoryPanel.FrameDisplaySupporter<StringBuilder> {
    private static final long serialVersionUID = 1704390033157269580L;
    protected Hashtable<String, BufferFrame> m_Frames;
    protected JTextArea m_TextArea;
    protected transient TextFileChooser m_FileChooser;
    protected boolean m_CaretAtStart;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Frames = new Hashtable();
        this.m_TextArea = null;
        this.m_CaretAtStart = false;
    }

    protected TextFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new TextFileChooser();
        }
        return this.m_FileChooser;
    }

    public void setTextArea(JTextArea value) {
        this.m_TextArea = value;
    }

    @Override
    protected void updateEntry(String name) {
        this.m_TextArea.setText("");
        if (name != null) {
            if (this.hasEntry(name)) {
                this.m_TextArea.setText(((StringBuilder)this.getEntry(name)).toString());
            }
            if (this.m_CaretAtStart) {
                this.m_TextArea.setCaretPosition(0);
            }
            if (this.hasFrame(name)) {
                this.showFrame(name);
            }
        }
    }

    @Override
    public boolean hasFrame(String name) {
        return this.m_Frames.containsKey(name);
    }

    public BufferFrame newFrame(String name) {
        BufferFrame result = new BufferFrame(this, name);
        this.m_Frames.put(name, result);
        return result;
    }

    public BufferFrame getFrame(String name) {
        return this.m_Frames.get(name);
    }

    @Override
    public void showFrame(String name) {
        BufferFrame frame;
        if (!this.hasFrame(name)) {
            frame = this.newFrame(name);
            frame.setLocationRelativeTo(this);
        } else {
            frame = this.getFrame(name);
        }
        frame.setVisible(true);
        frame.toFront();
    }

    @Override
    public void removeFrame(String name) {
        this.m_Frames.remove(name);
    }

    @Override
    public StringBuilder removeEntry(String name) {
        StringBuilder result = (StringBuilder)super.removeEntry(name);
        if (this.hasFrame(name)) {
            this.getFrame(name).setVisible(false);
        }
        return result;
    }

    @Override
    protected JPopupMenu createPopup(MouseEvent e) {
        JPopupMenu result = super.createPopup(e);
        final int[] indices = this.getSelectedIndices();
        result.addSeparator();
        JMenuItem menuitem = new JMenuItem("Save...");
        menuitem.setEnabled(indices.length == 1);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufferHistoryPanel.this.saveEntry(BufferHistoryPanel.this.getEntryName(indices[0]));
            }
        });
        result.add(menuitem);
        return result;
    }

    protected void saveEntry(String name) {
        String filename = name + "." + this.getFileChooser().getDefaultExtension();
        filename = FileUtils.createFilename(filename, "");
        this.getFileChooser().setSelectedFile(new File(filename));
        int retVal = this.getFileChooser().showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        FileUtils.writeToFile(this.getFileChooser().getSelectedFile().getAbsolutePath(), ((StringBuilder)this.getEntry(name)).toString(), false, this.getFileChooser().getEncoding());
    }

    public void setCaretAtStart(boolean value) {
        this.m_CaretAtStart = value;
        if (this.getSelectedEntry() != null) {
            this.updateEntry(this.getSelectedEntry());
        }
    }

    public boolean isCaretAtStart() {
        return this.m_CaretAtStart;
    }

    public static class BufferFrame
    extends AbstractNamedHistoryPanel.AbstractHistoryEntryFrame<StringBuilder> {
        private static final long serialVersionUID = 2552148773749071235L;
        protected JTextArea m_TextArea;

        public BufferFrame(AbstractNamedHistoryPanel<StringBuilder> owner, String name) {
            super(owner, name);
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.getContentPane().setLayout(new BorderLayout());
            this.m_TextArea = new JTextArea();
            this.m_TextArea.setFont(GUIHelper.getMonospacedFont());
            this.getContentPane().add((Component)new BaseScrollPane(this.m_TextArea), "Center");
        }

        @Override
        public void updateEntry() {
            StringBuilder buffer = (StringBuilder)this.getEntryOwner().getEntry(this.getEntryName());
            if (buffer != null) {
                this.m_TextArea.setText(buffer.toString());
            } else {
                this.m_TextArea.setText("");
            }
        }
    }
}

