/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import java.awt.Color;

public class ColorHelper {
    public static ColorNotation getNotation(String str) {
        if (str.startsWith("#")) {
            return ColorNotation.HEX;
        }
        if (str.indexOf(44) > 0) {
            return ColorNotation.RGB;
        }
        return ColorNotation.NAME;
    }

    public static Color valueOf(String str) {
        return ColorHelper.valueOf(str, Color.BLACK);
    }

    public static Color valueOf(String str, Color defColor) {
        Color result = defColor;
        ColorNotation notation = ColorHelper.getNotation(str);
        switch (notation) {
            case HEX: {
                str = str.replaceAll("#", "");
                if (str.length() == 6) {
                    result = new Color(Integer.parseInt(str.substring(0, 2), 16), Integer.parseInt(str.substring(2, 4), 16), Integer.parseInt(str.substring(4, 6), 16));
                    break;
                }
                if (str.length() != 8) break;
                result = new Color(Integer.parseInt(str.substring(2, 4), 16), Integer.parseInt(str.substring(4, 6), 16), Integer.parseInt(str.substring(6, 8), 16), Integer.parseInt(str.substring(0, 2), 16));
                break;
            }
            case RGB: {
                String[] parts = str.split(",");
                if (parts.length == 3) {
                    try {
                        result = new Color(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
                    }
                    catch (Exception e) {}
                    break;
                }
                if (parts.length != 4) break;
                try {
                    result = new Color(Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]), Integer.parseInt(parts[0]));
                }
                catch (Exception e) {}
                break;
            }
            case NAME: {
                str = str.toLowerCase();
                if (str.equals("black")) {
                    result = Color.BLACK;
                    break;
                }
                if (str.equals("blue")) {
                    result = Color.BLUE;
                    break;
                }
                if (str.equals("cyan")) {
                    result = Color.CYAN;
                    break;
                }
                if (str.equals("darkgray")) {
                    result = Color.DARK_GRAY;
                    break;
                }
                if (str.equals("darkgrey")) {
                    result = Color.DARK_GRAY;
                    break;
                }
                if (str.equals("gray")) {
                    result = Color.GRAY;
                    break;
                }
                if (str.equals("grey")) {
                    result = Color.GRAY;
                    break;
                }
                if (str.equals("green")) {
                    result = Color.GREEN;
                    break;
                }
                if (str.equals("lightgray")) {
                    result = Color.LIGHT_GRAY;
                    break;
                }
                if (str.equals("lightgrey")) {
                    result = Color.LIGHT_GRAY;
                    break;
                }
                if (str.equals("magenta")) {
                    result = Color.MAGENTA;
                    break;
                }
                if (str.equals("orange")) {
                    result = Color.ORANGE;
                    break;
                }
                if (str.equals("pink")) {
                    result = Color.PINK;
                    break;
                }
                if (str.equals("red")) {
                    result = Color.RED;
                    break;
                }
                if (str.equals("white")) {
                    result = Color.WHITE;
                    break;
                }
                if (!str.equals("yellow")) break;
                result = Color.YELLOW;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled color notation: " + (Object)((Object)notation));
            }
        }
        return result;
    }

    protected static String toHex(int i) {
        String result = Integer.toHexString(i);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        return result;
    }

    public static String toHex(Color color) {
        String result = color.getAlpha() < 255 ? "#" + ColorHelper.toHex(color.getAlpha()) + ColorHelper.toHex(color.getRed()) + ColorHelper.toHex(color.getGreen()) + ColorHelper.toHex(color.getBlue()) : "#" + ColorHelper.toHex(color.getRed()) + ColorHelper.toHex(color.getGreen()) + ColorHelper.toHex(color.getBlue());
        return result;
    }

    public static String toRGB(Color color) {
        if (color.getAlpha() < 255) {
            return color.getAlpha() + "," + color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    public static String toName(Color color) {
        if (color.equals(Color.BLACK)) {
            return "black";
        }
        if (color.equals(Color.BLUE)) {
            return "blue";
        }
        if (color.equals(Color.CYAN)) {
            return "cyan";
        }
        if (color.equals(Color.DARK_GRAY)) {
            return "darkgray";
        }
        if (color.equals(Color.GRAY)) {
            return "gray";
        }
        if (color.equals(Color.GREEN)) {
            return "green";
        }
        if (color.equals(Color.LIGHT_GRAY)) {
            return "lightgray";
        }
        if (color.equals(Color.MAGENTA)) {
            return "magenta";
        }
        if (color.equals(Color.ORANGE)) {
            return "orange";
        }
        if (color.equals(Color.PINK)) {
            return "pink";
        }
        if (color.equals(Color.RED)) {
            return "red";
        }
        if (color.equals(Color.WHITE)) {
            return "white";
        }
        if (color.equals(Color.YELLOW)) {
            return "yellow";
        }
        return null;
    }

    @MixedCopyright(author="brimborium", copyright="2012 stackoverflow", license=License.CC_BY_SA_3)
    public static Color getContrastColor(Color color) {
        double y = (299 * color.getRed() + 587 * color.getGreen() + 114 * color.getBlue()) / 1000;
        return y >= 128.0 ? Color.black : Color.white;
    }

    public static enum ColorNotation {
        HEX,
        RGB,
        NAME;

    }
}

