/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.dom;

import adams.gui.core.BaseTree;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.core.dom.DOMNode;
import adams.gui.core.dom.DOMRenderer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMTree
extends BaseTree {
    private static final long serialVersionUID = -3618290386432060103L;
    protected Node m_Node;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Node = null;
        this.getSelectionModel().setSelectionMode(1);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DOMTree.this.isEnabled() && MouseUtils.isRightClick(e)) {
                    e.consume();
                    DOMTree.this.showNodePopupMenu(e);
                } else {
                    super.mousePressed(e);
                }
            }
        });
        this.setCellRenderer(new DOMRenderer());
        this.buildTree();
    }

    protected DOMNode buildTree(DOMNode parent, Node node) {
        if (parent == null) {
            parent = new DOMNode("root", node);
            this.buildTree(parent, node);
        } else {
            DOMNode child = new DOMNode(node.getNodeName(), node);
            parent.add(child);
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                short type = list.item(i).getNodeType();
                if (type == 3 || type == 4) continue;
                this.buildTree(child, list.item(i));
            }
        }
        DOMNode result = parent;
        return result;
    }

    protected void buildTree() {
        DOMNode root = this.m_Node == null ? new DOMNode("empty", null) : this.buildTree(null, this.m_Node);
        this.setModel(new DefaultTreeModel(root));
        this.expand(root);
    }

    protected void showNodePopupMenu(MouseEvent e) {
        JPopupMenu menu = null;
        int selRow = this.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = this.getPathForLocation(e.getX(), e.getY());
        if (selPath == null) {
            return;
        }
        final DOMNode selNode = (DOMNode)selPath.getLastPathComponent();
        if (selRow > -1) {
            menu = new JPopupMenu();
            JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
            menuitem.setEnabled(selNode.hasValue());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GUIHelper.copyToClipboard(selNode.toTransferable());
                }
            });
            menu.add(menuitem);
        }
        if (menu != null) {
            menu.show(this, e.getX(), e.getY());
        }
    }

    public void setDOM(Node value) {
        this.m_Node = value;
        this.buildTree();
    }

    public Node getDOM() {
        return this.m_Node;
    }
}

