/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow;

import adams.core.Pausable;
import adams.core.Properties;
import adams.core.StatusMessageHandler;
import adams.core.Stoppable;
import adams.core.Utils;
import adams.core.VariablesHandler;
import adams.core.io.FileUtils;
import adams.core.io.FilenameProposer;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionConsumer;
import adams.core.option.OptionProducer;
import adams.data.io.input.FlowReader;
import adams.data.io.output.DefaultFlowWriter;
import adams.data.io.output.FlowWriter;
import adams.db.LogEntryHandler;
import adams.env.Environment;
import adams.flow.control.Breakpoint;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractDisplay;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.processor.AbstractActorProcessor;
import adams.gui.chooser.FlowFileChooser;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.TitleGenerator;
import adams.gui.core.Undo;
import adams.gui.core.UndoPanel;
import adams.gui.event.ActorChangeEvent;
import adams.gui.event.ActorChangeListener;
import adams.gui.event.UndoEvent;
import adams.gui.flow.FlowEditorPanel;
import adams.gui.flow.FlowPanelNotificationArea;
import adams.gui.flow.FlowTabbedPane;
import adams.gui.flow.StoragePanel;
import adams.gui.flow.tab.RegisteredBreakpointsTab;
import adams.gui.flow.tab.RegisteredDisplaysTab;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.tools.VariableManagementPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class FlowPanel
extends UndoPanel
implements StatusMessageHandler,
SendToActionSupporter {
    private static final long serialVersionUID = -3579084888256133873L;
    public static final String PREFIX_NEW = "new";
    public static final String PREFIX_FLOW = "Flow";
    protected static int m_Counter = 0;
    protected static Properties m_Properties;
    protected FlowTabbedPane m_Owner;
    protected AbstractActor m_CurrentFlow;
    protected AbstractActor m_LastFlow;
    protected File m_CurrentFile;
    protected FlowWorker m_CurrentWorker;
    protected Thread m_CurrentThread;
    protected boolean m_RunningSwingWorker;
    protected BaseSplitPane m_SplitPane;
    protected Tree m_Tree;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandler;
    protected FilenameProposer m_FilenameProposer;
    protected String m_LastVariableSearch;
    protected VariableManagementPanel m_PanelVariables;
    protected StoragePanel m_PanelStorage;
    protected TitleGenerator m_TitleGenerator;
    protected String m_Title;
    protected boolean m_Headless;
    protected boolean m_RunGC;
    protected boolean m_CheckOnSave;
    protected HashMap<Class, HashMap<String, AbstractDisplay>> m_RegisteredDisplays;
    protected HashMap<String, Breakpoint> m_RegisteredBreakpoints;
    protected FlowPanelNotificationArea m_PanelNotification;

    public FlowPanel() {
        this((FlowTabbedPane)null);
    }

    public FlowPanel(FlowTabbedPane owner) {
        this.m_Owner = owner;
        if (this.getEditor() != null) {
            this.m_RecentFilesHandler = this.getEditor().getRecentFilesHandler();
        }
        this.reset(new Flow());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_CurrentFlow = null;
        this.m_LastFlow = null;
        this.m_CurrentFile = null;
        this.m_RecentFilesHandler = null;
        this.m_CurrentWorker = null;
        this.m_LastVariableSearch = "";
        this.m_TitleGenerator = new TitleGenerator("Flow editor", true);
        this.m_FilenameProposer = new FilenameProposer(PREFIX_NEW, "flow", FlowPanel.getProperties().getPath("InitialDir", "%h"));
        this.m_Title = "";
        this.m_RegisteredDisplays = new HashMap();
        this.m_RegisteredBreakpoints = new HashMap();
        this.m_CheckOnSave = FlowPanel.getProperties().getBoolean("CheckOnSave", true);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = FlowPanel.getProperties();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane(0);
        this.m_SplitPane.setResizeWeight(1.0);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.add((Component)this.m_SplitPane, "Center");
        this.m_Tree = new Tree(this);
        this.m_Tree.setActorNameColor(props.getProperty("Tree.ActorName.Color", "black"));
        this.m_Tree.setActorNameSize(props.getProperty("Tree.ActorName.Size", "3"));
        this.m_Tree.setQuickInfoColor(props.getProperty("Tree.QuickInfo.Color", "#008800"));
        this.m_Tree.setQuickInfoSize(props.getProperty("Tree.QuickInfo.Size", "-2"));
        this.m_Tree.setAnnotationsColor(props.getProperty("Tree.Annotations.Color", "blue"));
        this.m_Tree.setAnnotationsSize(props.getProperty("Tree.Annotations.Size", "-2"));
        this.m_Tree.setInputOutputColor(props.getProperty("Tree.InputOutput.Color", "blue"));
        this.m_Tree.setInputOutputSize(props.getProperty("Tree.InputOutput.Size", "-2"));
        this.m_Tree.setPlaceholdersColor(props.getProperty("Tree.Placeholders.Color", "navy"));
        this.m_Tree.setPlaceholdersSize(props.getProperty("Tree.Placeholders.Size", "-2"));
        this.m_Tree.setStateUsesNested(props.getBoolean("Tree.StateUsesNested", true));
        this.m_Tree.setIgnoreNameChanges(props.getBoolean("Tree.IgnoreNameChanges", false));
        this.m_Tree.setIconScaleFactor(props.getDouble("Tree.IconScaleFactor", 1.0));
        this.m_Tree.setRecordAdd(props.getBoolean("Tree.RecordAdd", false));
        this.m_Tree.setVariableHighlightBackground(props.getProperty("VariableHighlight.Background", "#FFDD88"));
        this.m_Tree.setShowQuickInfo(props.getBoolean("ShowQuickInfo", true));
        this.m_Tree.setShowAnnotations(props.getBoolean("ShowAnnotations", true));
        this.m_Tree.setShowInputOutput(props.getBoolean("ShowInputOutput", false));
        this.m_Tree.setInputOutputPrefixes(props.getProperty("Tree.InputOutput.Prefixes", "java.lang.,java.io.,adams.core.io.,adams.flow.core.,adams.flow.container.").replace(" ", "").split(","));
        this.m_Tree.addActorChangeListener(new ActorChangeListener(){

            @Override
            public void actorChanged(ActorChangeEvent e) {
                FlowPanel.this.update();
            }
        });
        this.m_Tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (FlowPanel.this.m_Tree.getSelectionPath() != null) {
                    FlowPanel.this.showStatus(FlowPanel.this.m_Tree.getSelectedFullName());
                }
            }
        });
        this.m_SplitPane.setTopComponent(new BaseScrollPane(this.m_Tree));
        this.m_Tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (FlowPanel.this.getEditor() != null) {
                    FlowPanel.this.getEditor().getTabs().notifyTabs(FlowPanel.this.m_Tree.getSelectionPaths(), FlowPanel.this.m_Tree.getSelectedActors());
                }
            }
        });
        this.m_PanelNotification = new FlowPanelNotificationArea();
        this.m_PanelNotification.setOwner(this);
        this.m_PanelNotification.addCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowPanel.this.clearNotification();
            }
        });
        this.m_SplitPane.setBottomComponent(this.m_PanelNotification);
        this.m_SplitPane.setBottomComponentHidden(true);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.clearNotification();
    }

    public FlowTabbedPane getOwner() {
        return this.m_Owner;
    }

    public void setTabIcon(String icon) {
        int index;
        if (this.getOwner() != null && (index = this.getOwner().indexOfComponent(this)) != -1) {
            this.getOwner().setIconAt(index, icon == null ? null : GUIHelper.getIcon(icon));
        }
    }

    public FlowEditorPanel getEditor() {
        if (this.m_Owner != null) {
            return this.m_Owner.getOwner();
        }
        return null;
    }

    public void setHeadless(boolean value) {
        if (!this.isRunning() && !this.isStopping()) {
            this.m_Headless = value;
        }
    }

    public boolean isHeadless() {
        return this.m_Headless;
    }

    public void setRunGC(boolean value) {
        if (!this.isRunning() && !this.isStopping()) {
            this.m_RunGC = value;
        }
    }

    public boolean getRunGC() {
        return this.m_RunGC;
    }

    public void setCheckOnSave(boolean value) {
        this.m_CheckOnSave = value;
    }

    public boolean getCheckOnSave() {
        return this.m_CheckOnSave;
    }

    protected void updateWidgets() {
        boolean inputEnabled = !this.isRunning() && !this.isStopping();
        this.getTree().setEditable(inputEnabled);
    }

    protected void update() {
        this.updateWidgets();
        this.updateTitle();
        if (this.getOwner() != null && this.getOwner().getOwner() != null) {
            this.getOwner().getOwner().update();
        }
    }

    protected synchronized int next() {
        return ++m_Counter;
    }

    public void setTitle(String value) {
        this.m_Title = value;
    }

    public String getTitle() {
        return this.m_Title;
    }

    public void updateTitle() {
        int index;
        if (!this.m_TitleGenerator.isEnabled()) {
            return;
        }
        this.setParentTitle(this.m_TitleGenerator.generate(this.getCurrentFile(), this.getTree().isModified()));
        if (this.getOwner() != null && (index = this.getOwner().indexOfComponent(this)) != -1) {
            this.getOwner().setTitleAt(index, (this.isModified() ? "*" : "") + this.getTitle());
        }
    }

    public void reset(AbstractActor actor) {
        this.addUndoPoint("Saving undo data...", "New " + actor.getClass().getName().replaceAll(".*\\.", ""));
        this.cleanUp();
        this.m_CurrentFlow = null;
        this.getTree().setActor(null);
        this.getTree().setActor(actor);
        this.getTree().setModified(false);
        this.setCurrentFile(null);
        this.setTitle(PREFIX_NEW + this.next());
        this.update();
        this.grabFocus();
    }

    public void setCurrentFile(File value) {
        this.m_CurrentFile = value;
        if (value == null) {
            this.m_Title = "";
        } else if (value.getName().lastIndexOf(46) > -1) {
            String tmp = value.getName();
            if (tmp.toLowerCase().endsWith(".gz")) {
                tmp = tmp.substring(0, tmp.lastIndexOf(46));
            }
            this.m_Title = tmp.substring(0, tmp.lastIndexOf(46));
        } else {
            this.m_Title = value.getName();
        }
        this.getTree().setFile(value);
        if (this.getOwner() != null) {
            this.getOwner().updateCurrentDirectory();
        }
    }

    public File getCurrentFile() {
        return this.m_CurrentFile;
    }

    public TitleGenerator getTitleGenerator() {
        return this.m_TitleGenerator;
    }

    public void load(final FlowReader reader, final File file) {
        this.m_RunningSwingWorker = true;
        SwingWorker worker = new SwingWorker(){
            protected AbstractActor m_Flow = null;
            protected List<String> m_Errors;
            protected List<String> m_Warnings;

            protected Object doInBackground() throws Exception {
                this.m_Errors = new ArrayList<String>();
                this.m_Warnings = new ArrayList<String>();
                FlowPanel.this.cleanUp();
                FlowPanel.this.update();
                FlowPanel.this.addUndoPoint("Saving undo data...", "Loading '" + file.getName() + "'");
                FlowPanel.this.showStatus("Loading '" + file + "'...");
                this.m_Flow = (AbstractActor)reader.read(file);
                this.m_Errors.addAll(reader.getErrors());
                this.m_Warnings.addAll(reader.getWarnings());
                FlowPanel.this.setCurrentFlow(this.m_Flow);
                FlowPanel.this.m_Tree.redraw();
                FlowPanel.this.showStatus("");
                return null;
            }

            @Override
            protected void done() {
                FlowPanel.this.m_RunningSwingWorker = false;
                if (this.m_Errors.isEmpty()) {
                    FlowPanel.this.setCurrentFile(file);
                }
                if (FlowPanel.this.m_RecentFilesHandler != null) {
                    FlowPanel.this.m_RecentFilesHandler.addRecentItem(file);
                }
                if (!this.m_Errors.isEmpty()) {
                    GUIHelper.showErrorMessage(FlowPanel.this.m_Owner, "Failed to load flow '" + file + "':\n" + Utils.flatten(this.m_Errors, "\n") + (this.m_Warnings.isEmpty() ? "" : "\nWarning(s):\n" + Utils.flatten(this.m_Warnings, "\n")));
                }
                if (!this.m_Warnings.isEmpty()) {
                    GUIHelper.showErrorMessage(FlowPanel.this.m_Owner, "Warning(s) encountered while loading flow '" + file + "':\n" + Utils.flatten(this.m_Warnings, "\n"));
                }
                FlowPanel.this.update();
                super.done();
            }
        };
        worker.execute();
    }

    public void setCurrentFlow(AbstractActor flow) {
        this.m_CurrentFlow = flow;
        if (flow != null) {
            this.getTree().setActor(flow);
            this.getTree().setModified(false);
        }
        this.setCurrentFile(null);
        this.setTitle(PREFIX_FLOW + this.next());
    }

    public AbstractActor getCurrentFlow() {
        return this.getCurrentFlow(null);
    }

    public AbstractActor getCurrentFlow(StringBuilder errors) {
        return this.getTree().getActor(errors);
    }

    public AbstractActor getCurrentRoot() {
        return this.getTree().getRootActor();
    }

    public AbstractActor getRunningFlow() {
        if (this.isRunning()) {
            return this.m_CurrentFlow;
        }
        return null;
    }

    protected void setLastFlow(AbstractActor value) {
        this.m_LastFlow = value;
    }

    public AbstractActor getLastFlow() {
        return this.m_LastFlow;
    }

    public void setModified(boolean value) {
        this.getTree().setModified(value);
        this.update();
    }

    public boolean isModified() {
        return this.getTree().isModified();
    }

    public void revert() {
        this.cleanUp();
        FlowFileChooser filechooser = null;
        if (this.getOwner() != null && this.getOwner().getOwner() != null) {
            filechooser = this.getOwner().getOwner().getFileChooser();
        }
        if (filechooser == null) {
            filechooser = new FlowFileChooser();
        }
        this.load(filechooser.getReaderForFile(this.getCurrentFile()), this.getCurrentFile());
    }

    public void save(final FlowWriter writer, final File file) {
        int retVal;
        String check;
        final AbstractActor flow = this.getCurrentFlow();
        if (this.getCheckOnSave() && (check = ActorUtils.checkFlow(flow, false, false)) != null && (retVal = GUIHelper.showConfirmMessage(this.m_Owner, "Pre-save check failed - continue with save?\n\nDetails:\n\n" + check)) != 0) {
            this.showStatus("Cancelled saving!");
            return;
        }
        SwingWorker worker = new SwingWorker(){
            boolean m_Result;

            protected Object doInBackground() throws Exception {
                FlowPanel.this.showStatus("Saving '" + file + "'...");
                this.m_Result = writer.write((Actor)flow, file);
                FlowPanel.this.showStatus("");
                return null;
            }

            @Override
            protected void done() {
                if (!this.m_Result) {
                    GUIHelper.showErrorMessage(FlowPanel.this.m_Owner, "Error saving flow to '" + file.getAbsolutePath() + "'!");
                } else {
                    FlowPanel.this.showStatus("");
                    FlowPanel.this.getTree().setModified(false);
                    if (FlowPanel.this.m_RecentFilesHandler != null) {
                        FlowPanel.this.m_RecentFilesHandler.addRecentItem(file);
                    }
                    FlowPanel.this.setCurrentFile(file);
                }
                FlowPanel.this.update();
                super.done();
            }
        };
        worker.execute();
    }

    public void importFlow(OptionConsumer consumer, File file) {
        AbstractActor actor = (AbstractActor)consumer.fromFile(file);
        if (actor == null) {
            this.showNotification("Failed to load flow from:\n" + file, true);
        } else {
            this.getTree().setActor(actor);
            this.setCurrentFile(new PlaceholderFile(file.getAbsolutePath() + "." + "flow"));
            if (!consumer.hasErrors()) {
                this.showNotification("Flow successfully imported from:\n" + file, false);
            } else {
                this.showNotification("Flow import of:\n" + file + "\nResulted in errors:\n" + Utils.flatten(consumer.getErrors(), "\n"), true);
            }
        }
    }

    public void exportFlow(OptionProducer producer, File file) {
        producer.produce(this.getCurrentFlow());
        if (!FileUtils.writeToFile(file.getAbsolutePath(), (Object)producer.toString(), false)) {
            this.showNotification("Failed to export flow to:\n" + file, true);
        } else {
            this.showNotification("Flow successfully exported to:\n" + file, false);
        }
    }

    public void run() {
        this.run(true);
    }

    public void run(boolean showNotification) {
        this.m_CurrentWorker = new FlowWorker(this, this.getCurrentFlow(), this.getCurrentFile(), showNotification);
        this.m_CurrentThread = new Thread(this.m_CurrentWorker);
        this.m_CurrentThread.start();
    }

    protected void finishedExecution() {
        this.m_CurrentWorker = null;
        this.m_CurrentThread = null;
        this.update();
    }

    public boolean isRunning() {
        return this.m_CurrentWorker != null && this.m_CurrentWorker.isRunning();
    }

    public boolean isStopping() {
        return this.m_CurrentWorker != null && this.m_CurrentWorker.isStopping();
    }

    public boolean isPaused() {
        return this.isRunning() && this.m_CurrentWorker.isPaused();
    }

    public boolean isSwingWorkerRunning() {
        return this.m_RunningSwingWorker;
    }

    public boolean pauseAndResume() {
        boolean result = false;
        if (this.m_CurrentWorker != null) {
            if (!this.m_CurrentWorker.isPaused()) {
                this.m_CurrentWorker.pauseExecution();
                result = true;
            } else {
                this.m_CurrentWorker.resumeExecution();
                result = false;
            }
        }
        this.update();
        return result;
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(final boolean cleanUp) {
        if (this.m_CurrentWorker != null) {
            SwingWorker worker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    FlowPanel.this.m_CurrentWorker.stopExecution();
                    if (cleanUp) {
                        FlowPanel.this.cleanUp();
                    }
                    return null;
                }
            };
            worker.execute();
        }
    }

    public void kill() {
        if (this.m_CurrentThread != null) {
            try {
                this.m_CurrentThread.interrupt();
                this.m_CurrentThread.stop();
            }
            finally {
                this.setTabIcon(null);
                this.finishedExecution();
            }
        }
    }

    public void cleanUp() {
        if (this.m_LastFlow != null) {
            this.showStatus("Cleaning up");
            try {
                this.clearRegisteredDisplays();
                this.m_LastFlow.destroy();
                this.m_LastFlow = null;
                this.showStatus("");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showStatus("Error cleaning up: " + e);
            }
        }
    }

    public void close() {
        this.cleanUp();
        if (this.m_Owner != null) {
            this.m_Owner.remove(this);
        }
    }

    public void addUndoPoint(String statusMsg, String undoComment) {
        if (this.isUndoSupported() && this.getUndo().isEnabled()) {
            this.showStatus(statusMsg);
            this.getUndo().addUndo(this.getTree().getState(), undoComment);
            this.showStatus("");
        }
    }

    public void undo() {
        if (!this.getUndo().canUndo()) {
            return;
        }
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                FlowPanel.this.showStatus("Performing Undo...");
                FlowPanel.this.getUndo().addRedo(FlowPanel.this.getTree().getState(), FlowPanel.this.getUndo().peekUndoComment());
                Undo.UndoPoint point = FlowPanel.this.getUndo().undo();
                FlowPanel.this.getTree().setState((Vector)point.getData());
                FlowPanel.this.m_CurrentFile = FlowPanel.this.getTree().getFile();
                return "Done!";
            }

            @Override
            protected void done() {
                super.done();
                FlowPanel.this.update();
                FlowPanel.this.showStatus("");
            }
        };
        worker.execute();
    }

    public void redo() {
        if (!this.getUndo().canRedo()) {
            return;
        }
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                FlowPanel.this.showStatus("Performing Redo...");
                FlowPanel.this.getUndo().addUndo(FlowPanel.this.getTree().getState(), FlowPanel.this.getUndo().peekRedoComment(), true);
                Undo.UndoPoint point = FlowPanel.this.getUndo().redo();
                FlowPanel.this.getTree().setState((Vector)point.getData());
                FlowPanel.this.m_CurrentFile = FlowPanel.this.getTree().getFile();
                return "Done!";
            }

            @Override
            protected void done() {
                super.done();
                FlowPanel.this.update();
                FlowPanel.this.showStatus("");
            }
        };
        worker.execute();
    }

    public void setIgnoreNameChanges(boolean value) {
        this.m_Tree.setIgnoreNameChanges(value);
    }

    public boolean getIgnoreNameChanges() {
        return this.m_Tree.getIgnoreNameChanges();
    }

    public void processActorsPrompt(AbstractActorProcessor processor) {
        boolean selected;
        if (this.getTree().getSelectionCount() == 1 && !this.getTree().isRootSelected()) {
            int retVal = GUIHelper.showConfirmMessage(this, "Process only below selected actor instead of complete flow?\n" + this.getTree().getSelectedFullName());
            if (retVal == 2) {
                return;
            }
            selected = retVal == 0;
        } else {
            selected = false;
        }
        if (selected) {
            this.processSelectedActor(processor);
        } else {
            this.processActors(processor);
        }
    }

    public void processActors(AbstractActorProcessor processor) {
        if (this.getTree().processActor(null, processor)) {
            this.showNotification("Actors processed!", false);
        }
    }

    public void processSelectedActor(AbstractActorProcessor processor) {
        if (this.getTree().getSelectionRows().length != 1) {
            return;
        }
        TreePath path = this.getTree().getSelectionPath();
        Node node = (Node)path.getLastPathComponent();
        if (this.getTree().processActor(path, processor)) {
            this.showNotification("Actor " + node.getActor().getName() + " processed!", false);
        }
    }

    public void enableBreakpoints(boolean enable) {
        this.getTree().enableBreakpoints(enable);
    }

    protected VariableManagementPanel getVariablesPanel() {
        return this.m_PanelVariables;
    }

    public void showVariables() {
        if (this.m_PanelVariables == null) {
            this.m_PanelVariables = new VariableManagementPanel();
            BaseDialog dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog()) : new BaseDialog(this.getParentFrame());
            dialog.setTitle("Variables");
            dialog.getContentPane().setLayout(new BorderLayout());
            dialog.getContentPane().add((Component)this.m_PanelVariables, "Center");
            dialog.pack();
            dialog.setLocationRelativeTo(null);
        }
        this.m_PanelVariables.setVariables(this.m_CurrentFlow.getVariables());
        this.m_PanelVariables.getParentDialog().setVisible(true);
    }

    public void showStorage() {
        if (this.m_PanelStorage == null) {
            this.m_PanelStorage = new StoragePanel();
            BaseDialog dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog()) : new BaseDialog(this.getParentFrame());
            dialog.setTitle("Storage");
            dialog.getContentPane().setLayout(new BorderLayout());
            dialog.getContentPane().add((Component)this.m_PanelStorage, "Center");
            dialog.pack();
            dialog.setLocationRelativeTo(null);
        }
        this.m_PanelStorage.setHandler(this.m_CurrentFlow.getStorageHandler());
        this.m_PanelStorage.getParentDialog().setVisible(true);
    }

    public void closeStorage() {
        if (this.m_PanelStorage == null) {
            return;
        }
        this.m_PanelStorage.closeParent();
    }

    @Override
    public void showStatus(String msg) {
        if (this.getEditor() != null) {
            this.getEditor().showStatus(msg);
        }
    }

    @Override
    public void undoOccurred(UndoEvent e) {
        this.update();
    }

    @Override
    public void grabFocus() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FlowPanel.this.getTree().grabFocus();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public BaseSplitPane getSplitPane() {
        return this.m_SplitPane;
    }

    public Tree getTree() {
        return this.m_Tree;
    }

    public void setRecentFilesHandler(RecentFilesHandler<JMenu> value) {
        this.m_RecentFilesHandler = value;
    }

    public RecentFilesHandler<JMenu> getRecentFilesHandler() {
        return this.m_RecentFilesHandler;
    }

    @Override
    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JComponent.class};
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable(new Class[]{PlaceholderFile.class, JComponent.class}, cls) && (this.getTree().isModified() || this.getCurrentFile() != null);
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        Serializable result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, cls)) {
            if (this.getTree().isModified()) {
                result = SendToActionUtils.nextTmpFile("floweditor", "flow");
                AbstractActor actor = this.getCurrentFlow();
                DefaultFlowWriter writer = new DefaultFlowWriter();
                writer.write((Actor)actor, (PlaceholderFile)result);
            } else if (this.getCurrentFile() != null) {
                result = new PlaceholderFile(this.getCurrentFile());
            }
        } else if (SendToActionUtils.isAvailable(JComponent.class, cls)) {
            result = this.m_Tree;
        }
        return result;
    }

    public void redraw() {
        this.m_Tree.redraw();
    }

    protected void updateRegisteredDisplays(boolean show) {
        RegisteredDisplaysTab registered;
        if (!this.getEditor().getTabs().isVisible(RegisteredDisplaysTab.class) && show) {
            this.getEditor().getTabs().setVisible(RegisteredDisplaysTab.class, true, false);
        }
        if ((registered = (RegisteredDisplaysTab)this.getEditor().getTabs().getTab(RegisteredDisplaysTab.class)) != null) {
            registered.update();
        }
        if (!this.hasRegisteredDisplays()) {
            this.getEditor().getTabs().setVisible(RegisteredDisplaysTab.class, false, false);
        }
    }

    public AbstractDisplay registerDisplay(Class cls, String name, AbstractDisplay panel) {
        if (!this.m_RegisteredDisplays.containsKey(cls)) {
            this.m_RegisteredDisplays.put(cls, new HashMap());
        }
        HashMap<String, AbstractDisplay> panels = this.m_RegisteredDisplays.get(cls);
        AbstractDisplay result = panels.put(name, panel);
        this.updateRegisteredDisplays(true);
        return result;
    }

    public AbstractDisplay deregisterDisplay(Class cls, String name) {
        AbstractDisplay result = this.m_RegisteredDisplays.containsKey(cls) ? this.m_RegisteredDisplays.get(cls).remove(name) : null;
        if (result != null) {
            this.updateRegisteredDisplays(false);
        }
        return result;
    }

    public void clearRegisteredDisplays() {
        this.m_RegisteredDisplays.clear();
        this.updateRegisteredDisplays(false);
    }

    public HashMap<Class, HashMap<String, AbstractDisplay>> getRegisteredDisplays() {
        return this.m_RegisteredDisplays;
    }

    public boolean hasRegisteredDisplays() {
        int count = 0;
        for (Class cls : this.m_RegisteredDisplays.keySet()) {
            count += this.m_RegisteredDisplays.get(cls).size();
        }
        return count > 0;
    }

    protected void updateRegisteredBreakpoints(boolean show) {
        RegisteredBreakpointsTab registered;
        if (!this.getEditor().getTabs().isVisible(RegisteredBreakpointsTab.class) && show) {
            this.getEditor().getTabs().setVisible(RegisteredBreakpointsTab.class, true, false);
        }
        if ((registered = (RegisteredBreakpointsTab)this.getEditor().getTabs().getTab(RegisteredBreakpointsTab.class)) != null) {
            registered.update();
        }
        if (!this.hasRegisteredBreakpoints()) {
            this.getEditor().getTabs().setVisible(RegisteredBreakpointsTab.class, false, false);
        }
    }

    public Breakpoint registerBreakpoint(String name, Breakpoint panel) {
        Breakpoint result = this.m_RegisteredBreakpoints.put(name, panel);
        this.updateRegisteredBreakpoints(true);
        return result;
    }

    public Breakpoint deregisterBreakpoint(String name) {
        Breakpoint result = this.m_RegisteredBreakpoints.remove(name);
        this.updateRegisteredBreakpoints(false);
        return result;
    }

    public void clearRegisteredBreapoints() {
        this.m_RegisteredBreakpoints.clear();
        this.updateRegisteredBreakpoints(false);
    }

    public HashMap<String, Breakpoint> getRegisteredBreakpoints() {
        return this.m_RegisteredBreakpoints;
    }

    public boolean hasRegisteredBreakpoints() {
        return this.m_RegisteredBreakpoints.size() > 0;
    }

    public void showNotification(String msg, boolean error) {
        this.m_PanelNotification.showNotification(msg, error);
    }

    public void clearNotification() {
        this.m_PanelNotification.clearNotification();
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("flow editor panel");
        }
        return m_Properties;
    }

    public static class FlowWorker
    implements Runnable,
    Pausable,
    Stoppable,
    StatusMessageHandler {
        protected FlowPanel m_Owner;
        protected AbstractActor m_Flow;
        protected File m_File;
        protected String m_Output;
        protected boolean m_ShowNotification;
        protected boolean m_Running;
        protected boolean m_Stopping;

        public FlowWorker(FlowPanel owner, AbstractActor flow, File file, boolean showNotification) {
            this.m_Owner = owner;
            this.m_Flow = flow;
            this.m_File = file;
            this.m_ShowNotification = showNotification;
            this.m_Running = false;
            this.m_Stopping = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground() throws Exception {
            this.m_Owner.update();
            this.m_Owner.cleanUp();
            this.m_Owner.clearNotification();
            this.m_Owner.setTabIcon("run.gif");
            this.m_Running = true;
            this.m_Owner.update();
            try {
                this.showStatus("Initializing");
                this.m_Flow = ActorUtils.removeDisabledActors(this.m_Flow);
                this.m_Flow.setHeadless(this.m_Owner.isHeadless());
                if (this.m_Flow instanceof Flow) {
                    ((Flow)this.m_Flow).setParentComponent(this.m_Owner);
                }
                this.m_Output = this.m_Flow.setUp();
                if (this.m_Output == null && !this.m_Flow.isStopped()) {
                    if (this.m_Flow instanceof VariablesHandler && ActorUtils.updateVariablesWithFlowFilename((VariablesHandler)((Object)this.m_Flow), this.m_File) && this.m_Owner.isModified()) {
                        this.m_Flow.getLogger().warning("Flow '" + this.m_File + "' not saved, flow variables like '" + "flow_dir" + "' might not be accurate!");
                    }
                    this.showStatus("Running");
                    this.m_Output = this.m_Flow.execute();
                    if (this.m_Output == null && this.m_Flow.hasStopMessage()) {
                        this.m_Output = this.m_Flow.getStopMessage();
                    }
                    if (this.m_Stopping) {
                        while (!this.m_Flow.isStopped()) {
                            try {
                                FlowWorker flowWorker = this;
                                synchronized (flowWorker) {
                                    this.wait(100L);
                                }
                            }
                            catch (Exception e) {
                            }
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.m_Output = Utils.throwableToString(e);
            }
            if (this.m_Owner.getVariablesPanel() != null && this.m_Owner.getVariablesPanel().getParentDialog() != null) {
                this.m_Owner.getVariablesPanel().getParentDialog().setVisible(false);
            }
            return null;
        }

        protected void done() {
            int countErrors;
            this.showStatus("Finishing up");
            this.m_Flow.wrapUp();
            this.m_Owner.clearRegisteredBreapoints();
            if (this.m_Owner.getRunGC()) {
                System.gc();
            }
            this.m_Owner.setLastFlow(this.m_Flow);
            this.m_Flow = null;
            String errors = null;
            if (this.m_Owner.getLastFlow() instanceof LogEntryHandler && (countErrors = ((LogEntryHandler)((Object)this.m_Owner.getLastFlow())).countLogEntries()) > 0) {
                errors = countErrors + " error(s) logged";
            }
            if (this.m_Output != null) {
                String msg = "Finished with error: " + this.m_Output;
                if (errors != null) {
                    msg = msg + "(" + errors + ")";
                }
                this.showStatus(msg);
                if (this.m_ShowNotification) {
                    this.showNotification(this.m_Output, true);
                }
            } else {
                String msg = this.m_Running ? "Flow finished." : "User stopped flow.";
                if (errors != null) {
                    msg = msg + " " + errors + ".";
                }
                this.showStatus(msg);
                if (this.m_ShowNotification) {
                    this.m_Owner.showNotification(msg, !this.m_Running);
                }
            }
            this.m_Running = false;
            this.m_Stopping = false;
            this.m_Owner.update();
            this.m_Owner.finishedExecution();
        }

        @Override
        public void run() {
            try {
                this.doInBackground();
            }
            catch (Throwable t) {
                this.m_Output = Utils.throwableToString(t);
            }
            finally {
                this.done();
            }
        }

        @Override
        public void pauseExecution() {
            this.showStatus("Pausing");
            ((Pausable)((Object)this.m_Flow)).pauseExecution();
            this.m_Owner.setTabIcon("pause.gif");
            this.m_Owner.update();
        }

        @Override
        public boolean isPaused() {
            return ((Pausable)((Object)this.m_Flow)).isPaused();
        }

        @Override
        public void resumeExecution() {
            this.showStatus("Resuming");
            ((Pausable)((Object)this.m_Flow)).resumeExecution();
            this.m_Owner.setTabIcon("run.gif");
            this.m_Owner.update();
        }

        @Override
        public void stopExecution() {
            this.m_Stopping = true;
            this.m_Running = false;
            this.showStatus("Stopping");
            this.m_Owner.update();
            this.m_Flow.stopExecution();
        }

        public boolean isRunning() {
            return this.m_Running;
        }

        public boolean isStopping() {
            return this.m_Stopping;
        }

        @Override
        public void showStatus(String msg) {
            this.m_Owner.showStatus(msg);
        }

        public void showNotification(String msg, boolean isError) {
            this.m_Owner.showNotification(msg, isError);
        }
    }
}

