/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tab;

import adams.core.Utils;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.gui.core.GUIHelper;
import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.tab.AbstractEditorTab;
import adams.gui.flow.tab.SelectionAwareEditorTab;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import adams.gui.flow.tree.postprocessor.AbstractEditPostProcessor;
import adams.gui.goe.Favorites;
import adams.gui.goe.GenericObjectEditor;
import adams.gui.goe.GenericObjectEditorPopupMenu;
import adams.gui.goe.PropertySheetPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;

public class ActorQuickEditTab
extends AbstractEditorTab
implements SelectionAwareEditorTab {
    private static final long serialVersionUID = 3860012648562358118L;
    public static final String NO_SELECTION_TEXT = "<html><center><b>Please select an actor</b></center></html>";
    protected GenericObjectEditor m_Editor;
    protected OptionsPanel m_PanelEditor;
    protected JPanel m_PanelError;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Editor = new GenericObjectEditor();
        this.m_Editor.setClassType(Actor.class);
        this.m_Editor.setCanChangeClassInDialog(false);
        this.m_PanelEditor = new OptionsPanel(this, this.m_Editor);
        this.m_PanelError = new JPanel(new FlowLayout(1));
        this.m_PanelError.add(new JLabel(NO_SELECTION_TEXT));
        this.add((Component)this.m_PanelError, "Center");
    }

    @Override
    public String getTitle() {
        return "Quick Edit";
    }

    @Override
    public void actorSelectionChanged(TreePath[] paths, AbstractActor[] actors) {
        if (actors.length != 1) {
            this.remove(this.m_PanelEditor);
            this.add((Component)this.m_PanelError, "Center");
            return;
        }
        this.m_Editor.setValue(actors[0]);
        this.m_PanelEditor.setTreePath(paths[0]);
        this.remove(this.m_PanelError);
        this.add((Component)this.m_PanelEditor, "Center");
    }

    public static class OptionsPanel
    extends JPanel {
        static final long serialVersionUID = 3656028520876011335L;
        protected OptionsPanel m_Self;
        protected ActorQuickEditTab m_Owner;
        protected GenericObjectEditor m_Editor;
        protected Object m_Object;
        protected Object m_Backup;
        protected TreePath m_TreePath;
        protected PropertySheetPanel m_PanelProperties;
        protected JLabel m_LabelClassname;
        protected JButton m_ButtonApply;
        protected JButton m_ButtonRevert;
        protected JButton m_ButtonCopyPaste;
        protected JPanel m_TopPanel;
        protected boolean m_IgnoreChanges;

        public OptionsPanel(ActorQuickEditTab owner, GenericObjectEditor editor) {
            this.m_Owner = owner;
            this.m_Editor = editor;
            this.m_Editor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    OptionsPanel.this.m_Object = OptionsPanel.this.m_Editor.getValue();
                    OptionsPanel.this.m_Backup = OptionsPanel.this.copyObject(OptionsPanel.this.m_Object);
                    OptionsPanel.this.updateProperties();
                }
            });
            this.m_Object = this.m_Editor.getValue();
            this.m_Backup = this.copyObject(this.m_Object);
            this.m_LabelClassname = new JLabel("None");
            this.m_PanelProperties = new PropertySheetPanel();
            this.m_ButtonApply = new JButton("Apply");
            this.m_ButtonApply.setEnabled(true);
            this.m_ButtonApply.setToolTipText("Apply changes");
            this.m_ButtonApply.setMnemonic('A');
            this.m_ButtonApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsPanel.this.m_Object = OptionsPanel.this.m_PanelProperties.getTarget();
                    if (OptionsPanel.this.m_TreePath == null) {
                        System.err.println("No path linking back to actor tree, cannot apply settings!");
                        return;
                    }
                    Tree tree = OptionsPanel.this.m_Owner.getCurrentPanel().getTree();
                    Node node = (Node)OptionsPanel.this.m_TreePath.getLastPathComponent();
                    Node parent = (Node)node.getParent();
                    node.setActor((AbstractActor)OptionsPanel.this.m_Object);
                    tree.updateActorName(node);
                    tree.setModified(true);
                    tree.nodeStructureChanged(node);
                    tree.notifyActorChangeListeners(new ActorChangeEvent(tree, node, ActorChangeEvent.Type.MODIFY));
                    if (!tree.getIgnoreNameChanges()) {
                        AbstractEditPostProcessor.apply(tree, parent != null ? parent.getActor() : null, (AbstractActor)OptionsPanel.this.m_Backup, node.getActor());
                    }
                    OptionsPanel.this.m_Backup = OptionsPanel.this.copyObject(OptionsPanel.this.m_Object);
                }
            });
            this.m_ButtonRevert = new JButton(GUIHelper.getIcon("undo.gif"));
            this.m_ButtonRevert.setEnabled(true);
            this.m_ButtonRevert.setToolTipText("Revert changes");
            this.m_ButtonRevert.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (OptionsPanel.this.m_Backup != null) {
                        OptionsPanel.this.m_Editor.setValue(OptionsPanel.this.copyObject(OptionsPanel.this.m_Backup));
                        OptionsPanel.this.m_Editor.firePropertyChange();
                    }
                }
            });
            this.setLayout(new BorderLayout());
            this.m_ButtonCopyPaste = new JButton("...");
            this.m_ButtonCopyPaste.setToolTipText("Displays copy/paste/favorites action menu");
            this.m_ButtonCopyPaste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenericObjectEditorPopupMenu menu = new GenericObjectEditorPopupMenu(OptionsPanel.this.m_Editor, OptionsPanel.this.m_ButtonCopyPaste);
                    menu.addSeparator();
                    Favorites.getSingleton().customizePopupMenu(menu, OptionsPanel.this.m_Editor.getClassType(), OptionsPanel.this.m_Editor.getValue(), new Favorites.FavoriteSelectionListener(){

                        @Override
                        public void favoriteSelected(Favorites.FavoriteSelectionEvent e) {
                            OptionsPanel.this.m_Editor.setValue(e.getFavorite().getObject());
                        }
                    });
                    menu.show(OptionsPanel.this.m_ButtonCopyPaste, 0, OptionsPanel.this.m_ButtonCopyPaste.getHeight());
                }
            });
            this.m_TopPanel = new JPanel(new BorderLayout());
            this.m_TopPanel.add((Component)this.m_LabelClassname, "Center");
            JPanel chooseButtonPanel = new JPanel(new FlowLayout(2));
            chooseButtonPanel.add(this.m_ButtonCopyPaste);
            this.m_TopPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_TopPanel.add((Component)chooseButtonPanel, "East");
            this.add((Component)this.m_TopPanel, "North");
            JPanel childPanel = new JPanel(new BorderLayout());
            childPanel.add((Component)this.m_PanelProperties, "Center");
            this.add((Component)childPanel, "Center");
            JPanel allButs = new JPanel(new GridLayout(1, 2));
            JPanel rightButs = new JPanel();
            allButs.add((Component)rightButs, "East");
            allButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            rightButs.setLayout(new FlowLayout(2));
            rightButs.add(this.m_ButtonApply);
            rightButs.add(this.m_ButtonRevert);
            this.add((Component)allButs, "South");
            if (this.m_Editor.getClassType() != null && this.m_Editor.getValue() != null) {
                this.updateProperties();
            }
        }

        protected Object copyObject(Object source) {
            return Utils.deepCopy(source);
        }

        public void updateProperties() {
            this.m_IgnoreChanges = true;
            String classname = "None";
            if (this.m_Object != null) {
                classname = this.m_Object.getClass().getName();
            }
            this.m_LabelClassname.setText(classname);
            this.m_PanelProperties.setTarget(this.m_Object);
            this.m_IgnoreChanges = false;
        }

        public void setTreePath(TreePath value) {
            this.m_TreePath = value;
            this.m_ButtonApply.setEnabled(value != null);
        }

        public TreePath getTreePath() {
            return this.m_TreePath;
        }
    }
}

