/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tab;

import adams.flow.control.Breakpoint;
import adams.gui.core.BaseTabbedPane;
import adams.gui.flow.FlowPanel;
import adams.gui.flow.tab.AbstractTabChangeAwareEditorTab;
import adams.gui.flow.tab.RuntimeTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;

public class RegisteredBreakpointsTab
extends AbstractTabChangeAwareEditorTab
implements RuntimeTab {
    private static final long serialVersionUID = 3636125950515045125L;

    @Override
    public String getTitle() {
        return "Breakpoints";
    }

    public void update() {
        this.flowPanelChanged(this.getCurrentPanel());
    }

    @Override
    public synchronized void flowPanelChanged(FlowPanel panel) {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.getParent() != null) {
            this.getParent().invalidate();
            this.getParent().doLayout();
            this.getParent().repaint();
        }
        if (panel == null) {
            return;
        }
        HashMap<String, Breakpoint> panels = panel.getRegisteredBreakpoints();
        if (panels.size() == 0) {
            return;
        }
        BaseTabbedPane tabbedPanels = new BaseTabbedPane(1);
        for (String name : panels.keySet()) {
            Breakpoint breakpoint = panels.get(name);
            String title = name;
            if (breakpoint.getParentComponent() instanceof FlowPanel) {
                title = ((FlowPanel)breakpoint.getParentComponent()).getTitle() + ":" + title;
            }
            tabbedPanels.addTab(title, breakpoint.getPanel());
        }
        this.add((Component)tabbedPanels, "Center");
        if (this.getParent() != null) {
            this.getParent().invalidate();
            this.getParent().doLayout();
            this.getParent().repaint();
        }
    }
}

