/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.TreeHelper;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItemAction;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.tree.TreePath;

public class RemoveActor
extends AbstractTreePopupMenuItemAction {
    private static final long serialVersionUID = 3991575839421394939L;

    @Override
    protected String getTitle() {
        return "Remove";
    }

    @Override
    protected void doUpdate() {
        this.setEnabled(((StateContainer)this.m_State).editable && ((StateContainer)this.m_State).canRemove);
    }

    protected void removeActor(TreePath[] paths) {
        Node[] nodes = TreeHelper.pathsToNodes(paths);
        if (nodes.length == 1) {
            this.addUndoPoint("Removing node '" + nodes[0].getActor().getFullName() + "'");
        } else {
            this.addUndoPoint("Removing nodes");
        }
        Vector<Boolean> state = new Vector<Boolean>(((StateContainer)this.m_State).tree.getExpandedStateList());
        Node selNode = null;
        for (int i = nodes.length - 1; i >= 0; --i) {
            Node node = nodes[i];
            Node parent = (Node)node.getParent();
            int index = parent.getIndex(node);
            int row = ((StateContainer)this.m_State).tree.getRowForPath(paths[i]);
            parent.remove(index);
            ((StateContainer)this.m_State).tree.nodeStructureChanged(parent);
            state.remove(row);
            selNode = parent.getChildCount() > index ? (Node)parent.getChildAt(index) : (parent.getChildCount() > 0 && parent.getChildCount() > index - 1 ? (Node)parent.getChildAt(index - 1) : parent);
        }
        ((StateContainer)this.m_State).tree.setExpandedStateList(state);
        if (selNode != null) {
            ((StateContainer)this.m_State).tree.locateAndDisplay(selNode.getFullName());
        }
        ((StateContainer)this.m_State).tree.setModified(true);
        if (nodes.length == 1) {
            ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, nodes[0], ActorChangeEvent.Type.REMOVE));
        } else {
            ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, nodes, ActorChangeEvent.Type.REMOVE_RANGE));
        }
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        this.removeActor(((StateContainer)this.m_State).selPaths);
    }
}

