/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.flow.core.AbstractActor;
import adams.gui.core.GUIHelper;
import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.TreeHelper;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItemAction;
import adams.gui.flow.tree.postprocessor.AbstractEditPostProcessor;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class RenameActor
extends AbstractTreePopupMenuItemAction {
    private static final long serialVersionUID = 3991575839421394939L;

    @Override
    protected String getTitle() {
        return "Rename...";
    }

    @Override
    protected void doUpdate() {
        this.setEnabled(((StateContainer)this.m_State).editable && ((StateContainer)this.m_State).isSingleSel);
    }

    protected void renameActor(TreePath path) {
        Node node = TreeHelper.pathToNode(path);
        String oldName = node.getActor().getName();
        String newName = GUIHelper.showInputDialog(GUIHelper.getParentComponent(((StateContainer)this.m_State).tree), "Please enter new name:", oldName);
        if (newName != null) {
            AbstractActor actorOld = node.getActor();
            if (newName.length() == 0) {
                newName = actorOld.getDefaultName();
            }
            this.addUndoPoint("Renaming actor " + actorOld.getName() + " to " + newName);
            List<TreePath> exp = ((StateContainer)this.m_State).tree.getExpandedNodes();
            AbstractActor actorNew = actorOld.shallowCopy();
            actorNew.setName(newName);
            node.setActor(actorNew);
            ((StateContainer)this.m_State).tree.updateActorName(node);
            ((DefaultTreeModel)((StateContainer)this.m_State).tree.getModel()).nodeChanged(node);
            ((StateContainer)this.m_State).tree.setModified(((StateContainer)this.m_State).tree.isModified() || !oldName.equals(node.getActor().getName()));
            ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, node, ActorChangeEvent.Type.MODIFY));
            ((StateContainer)this.m_State).tree.setExpandedNodes(exp);
            Node parent = (Node)node.getParent();
            if (!((StateContainer)this.m_State).tree.getIgnoreNameChanges()) {
                AbstractEditPostProcessor.apply(((StateContainer)this.m_State).tree, parent != null ? parent.getActor() : null, actorOld, actorNew);
            }
            ((StateContainer)this.m_State).tree.locateAndDisplay(node.getFullName());
        }
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        this.renameActor(((StateContainer)this.m_State).selPath);
    }
}

