/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Properties;
import adams.env.Environment;
import adams.gui.core.GUIHelper;
import adams.gui.goe.AbstractSimpleScriptEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class AbstractSimpleScriptEditorWithTemplates
extends AbstractSimpleScriptEditor {
    public static final String FILENAME = "AbstractSimpleScriptEditorTemplates.props";
    protected static Properties m_Properties;

    protected abstract String getKey();

    protected String[] getTemplates() {
        ArrayList<String> result = new ArrayList<String>();
        String value = AbstractSimpleScriptEditorWithTemplates.getProperties().getProperty(this.getKey());
        if (value != null) {
            String[] parts;
            for (String part : parts = value.replaceAll(" ", "").split(",")) {
                result.add(part);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    protected String loadTemplate(String name) {
        StringBuilder result = new StringBuilder();
        try {
            int read;
            byte[] buffer = new byte[1024];
            BufferedInputStream stream = new BufferedInputStream(ClassLoader.getSystemResourceAsStream(name));
            while ((read = ((InputStream)stream).read(buffer)) >= 0) {
                result.append(new String(buffer, 0, read));
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load template: " + name);
            e.printStackTrace();
            return null;
        }
        return result.toString();
    }

    @Override
    protected void addAdditionalMenuItems(JPopupMenu menu) {
        super.addAdditionalMenuItems(menu);
        String[] templates = this.getTemplates();
        if (templates.length == 0) {
            return;
        }
        JMenu submenu = new JMenu("Templates");
        submenu.setIcon(GUIHelper.getIcon("template.gif"));
        menu.add(submenu);
        for (final String template : templates) {
            File file = new File(template);
            JMenuItem menuitem = new JMenuItem(file.getName());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String content = AbstractSimpleScriptEditorWithTemplates.this.loadTemplate(template);
                    if (content != null) {
                        AbstractSimpleScriptEditorWithTemplates.this.m_TextStatement.setContent(content);
                    }
                }
            });
            submenu.add(menuitem);
        }
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("simple script editor templates");
        }
        return m_Properties;
    }
}

