/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.CloneHandler;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;

public class PropertyPath {
    public static PropertyContainer find(Object src, String path) {
        return PropertyPath.find(src, new Path(path));
    }

    public static PropertyContainer find(Object src, Path path) {
        PropertyContainer result;
        PathElement part = path.get(0);
        PropertyDescriptor desc = null;
        Method read = null;
        Method write = null;
        if (part.getType() == PathElementType.LIST) {
            try {
                read = src.getClass().getMethod("get", Integer.TYPE);
                write = src.getClass().getMethod("set", Integer.TYPE, Object.class);
            }
            catch (Exception e) {
                read = null;
                write = null;
            }
            if (read == null) {
                return null;
            }
            if (path.size() == 1) {
                result = new PropertyContainer(read, write, src);
            } else {
                try {
                    Object methodResult = read.invoke(src, part.getIndex());
                    Object newSrc = part.getType() == PathElementType.ARRAY ? Array.get(methodResult, part.getIndex()) : methodResult;
                    result = PropertyPath.find(newSrc, path.subpath(1));
                }
                catch (Exception e) {
                    result = null;
                    e.printStackTrace();
                }
            }
        } else {
            try {
                desc = new PropertyDescriptor(part.getName(), src.getClass());
            }
            catch (Exception e) {
                desc = null;
                e.printStackTrace();
            }
            if (desc == null) {
                return null;
            }
            if (path.size() == 1) {
                result = new PropertyContainer(desc, src);
            } else {
                try {
                    Method method = desc.getReadMethod();
                    Object methodResult = method.invoke(src, (Object[])null);
                    Object newSrc = part.getType() == PathElementType.ARRAY ? Array.get(methodResult, part.getIndex()) : methodResult;
                    result = PropertyPath.find(newSrc, path.subpath(1));
                }
                catch (Exception e) {
                    result = null;
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static Object getValue(Object src, Path path) {
        Object result = null;
        PropertyContainer cont = PropertyPath.find(src, path);
        if (cont == null) {
            return null;
        }
        try {
            PathElement part = path.get(path.size() - 1);
            Method method = cont.getReadMethod();
            Object methodResult = part.getType() == PathElementType.LIST ? method.invoke(cont.getObject(), part.getIndex()) : method.invoke(cont.getObject(), (Object[])null);
            result = part.getType() == PathElementType.ARRAY ? Array.get(methodResult, part.getIndex()) : methodResult;
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public static Object getValue(Object src, String path) {
        return PropertyPath.getValue(src, new Path(path));
    }

    public static boolean setValue(Object src, Path path, Object value) {
        boolean result = false;
        PropertyContainer cont = PropertyPath.find(src, path);
        if (cont == null) {
            return result;
        }
        try {
            PathElement part = path.get(path.size() - 1);
            Method methodRead = cont.getReadMethod();
            Method methodWrite = cont.getWriteMethod();
            if (part.getType() == PathElementType.ARRAY) {
                Object methodResult = methodRead.invoke(cont.getObject(), (Object[])null);
                Array.set(methodResult, part.getIndex(), value);
                methodWrite.invoke(cont.getObject(), methodResult);
            } else {
                methodWrite.invoke(cont.getObject(), value);
            }
            result = true;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public static boolean setValue(Object src, String path, Object value) {
        return PropertyPath.setValue(src, new Path(path), value);
    }

    public static void main(String[] args) throws Exception {
        Path path = new Path("hello.world[2].nothing");
        System.out.println("Path: " + path);
        System.out.println(" -size: " + path.size());
        System.out.println(" -elements:");
        for (int i = 0; i < path.size(); ++i) {
            System.out.println("  " + i + ". " + path.get(i).getName() + " -> " + path.get(i).getIndex());
        }
    }

    public static class PropertyContainer {
        protected PropertyDescriptor m_Descriptor;
        protected Method m_Read;
        protected Method m_Write;
        protected Object m_Object;

        public PropertyContainer(PropertyDescriptor desc, Object obj) {
            this.m_Descriptor = desc;
            this.m_Read = null;
            this.m_Write = null;
            this.m_Object = obj;
        }

        public PropertyContainer(Method read, Method write, Object obj) {
            this.m_Descriptor = null;
            this.m_Read = read;
            this.m_Write = write;
            this.m_Object = obj;
        }

        public Method getReadMethod() {
            if (this.m_Read != null) {
                return this.m_Read;
            }
            return this.m_Descriptor.getReadMethod();
        }

        public Method getWriteMethod() {
            if (this.m_Write != null) {
                return this.m_Write;
            }
            return this.m_Descriptor.getWriteMethod();
        }

        public Object getObject() {
            return this.m_Object;
        }
    }

    public static class Path {
        protected Vector m_Elements = new Vector();

        protected Path() {
        }

        public Path(String path) {
            this();
            this.m_Elements = this.breakUp(path);
        }

        public Path(Vector elements) {
            this();
            for (int i = 0; i < elements.size(); ++i) {
                this.m_Elements.add(((PathElement)elements.get(i)).getClone());
            }
        }

        public Path(String[] elements) {
            this();
            for (int i = 0; i < elements.length; ++i) {
                this.m_Elements.add(new PathElement(elements[i]));
            }
        }

        protected Vector breakUp(String path) {
            Vector<PathElement> result = new Vector<PathElement>();
            StringTokenizer tok = new StringTokenizer(path, ".");
            while (tok.hasMoreTokens()) {
                result.add(new PathElement(tok.nextToken()));
            }
            return result;
        }

        public PathElement get(int index) {
            return (PathElement)this.m_Elements.get(index);
        }

        public int size() {
            return this.m_Elements.size();
        }

        public static Path parsePath(String path) {
            return new Path(path);
        }

        public Path subpath(int startIndex) {
            return this.subpath(startIndex, this.size());
        }

        public Path subpath(int startIndex, int endIndex) {
            Vector<PathElement> list = new Vector<PathElement>();
            for (int i = startIndex; i < endIndex; ++i) {
                list.add(this.get(i));
            }
            return new Path(list);
        }

        public String toString() {
            String result = "";
            for (int i = 0; i < this.m_Elements.size(); ++i) {
                if (i > 0) {
                    result = result + ".";
                }
                result = result + this.m_Elements.get(i);
            }
            return result;
        }
    }

    public static class PathElement
    implements CloneHandler<PathElement> {
        protected String m_Name;
        protected int m_Index;
        protected PathElementType m_Type;

        public PathElement(String property) {
            if (property.indexOf("[") > -1) {
                this.m_Name = property.replaceAll("\\[.*$", "");
                this.m_Index = Integer.parseInt(property.replaceAll(".*\\[", "").replaceAll("\\].*", ""));
                this.m_Type = PathElementType.ARRAY;
            } else if (property.indexOf("(") > -1) {
                this.m_Name = property.replaceAll("\\(.*$", "");
                if (!this.m_Name.equals("get")) {
                    throw new IllegalArgumentException("The path element used for lists must be 'get', provided: '" + this.m_Name + "'");
                }
                this.m_Index = Integer.parseInt(property.replaceAll(".*\\(", "").replaceAll("\\).*", ""));
                this.m_Type = PathElementType.LIST;
            } else {
                this.m_Name = property;
                this.m_Index = -1;
                this.m_Type = PathElementType.OBJECT;
            }
        }

        @Override
        public PathElement getClone() {
            return new PathElement(this.toString());
        }

        public String getName() {
            return this.m_Name;
        }

        public int getIndex() {
            return this.m_Index;
        }

        public PathElementType getType() {
            return this.m_Type;
        }

        public String toString() {
            String result = this.getName();
            switch (this.m_Type) {
                case OBJECT: {
                    break;
                }
                case ARRAY: {
                    result = result + "[" + this.getIndex() + "]";
                    break;
                }
                case LIST: {
                    result = result + "(" + this.getIndex() + ")";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled path element type: " + (Object)((Object)this.m_Type));
                }
            }
            return result;
        }
    }

    public static enum PathElementType {
        OBJECT,
        ARRAY,
        LIST;

    }
}

