/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe.classtree;

import adams.core.ClassLocator;
import adams.core.Utils;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Compatibility;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.gui.core.dotnotationtree.AbstractItemFilter;
import adams.gui.goe.classtree.StrictClassTreeFilter;
import java.util.Hashtable;

public class ActorClassTreeFilter
extends AbstractItemFilter
implements StrictClassTreeFilter {
    protected Class[] m_Accepts;
    protected Class[] m_Generates;
    protected Compatibility m_Compatibility;
    protected boolean m_StandalonesAllowed;
    protected boolean m_SourcesAllowed;
    protected Class[] m_Restrictions;
    protected static Hashtable<Class, AbstractActor> m_Cache = new Hashtable();

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Compatibility = new Compatibility();
        this.m_Accepts = null;
        this.m_Generates = null;
        this.m_StandalonesAllowed = true;
        this.m_SourcesAllowed = true;
        this.m_Restrictions = new Class[0];
    }

    @Override
    public void setStrict(boolean value) {
        this.m_Compatibility.setStrict(value);
    }

    @Override
    public boolean isStrict() {
        return this.m_Compatibility.isStrict();
    }

    public void setStandalonesAllowed(boolean value) {
        this.m_StandalonesAllowed = value;
    }

    public boolean getStandalonesAllowed() {
        return this.m_StandalonesAllowed;
    }

    public void setSourcesAllowed(boolean value) {
        this.m_SourcesAllowed = value;
    }

    public boolean getSourcesAllowed() {
        return this.m_SourcesAllowed;
    }

    public void setAccepts(Class[] value) {
        this.m_Accepts = value;
    }

    public Class[] getAccepts() {
        return this.m_Accepts;
    }

    public void setGenerates(Class[] value) {
        this.m_Generates = value;
    }

    public Class[] getGenerates() {
        return this.m_Generates;
    }

    public void setRestrictions(Class[] value) {
        this.m_Restrictions = value;
    }

    public Class[] getRestrictions() {
        return this.m_Restrictions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doFilter(String item) {
        Class<?> cls;
        boolean result = true;
        if (this.m_Accepts == null && this.m_Generates == null && this.m_StandalonesAllowed && this.m_SourcesAllowed && this.m_Restrictions == null) {
            return result;
        }
        try {
            cls = Class.forName(item);
        }
        catch (Exception e) {
            return result;
        }
        Class[] classArray = m_Cache;
        synchronized (m_Cache) {
            AbstractActor actor;
            if (!m_Cache.containsKey(cls)) {
                try {
                    actor = (AbstractActor)cls.newInstance();
                    m_Cache.put(cls, actor);
                }
                catch (Exception e) {
                    actor = null;
                }
            } else {
                actor = m_Cache.get(cls);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (actor == null) {
                result = false;
            }
            if (result && !this.m_StandalonesAllowed) {
                boolean bl = result = !ActorUtils.isStandalone(actor);
            }
            if (result && !this.m_SourcesAllowed) {
                boolean bl = result = !ActorUtils.isSource(actor);
            }
            if (result && this.m_Accepts != null) {
                boolean bl = result = actor instanceof InputConsumer && this.m_Compatibility.isCompatible(this.m_Accepts, ((InputConsumer)((Object)actor)).accepts());
            }
            if (result && this.m_Generates != null) {
                boolean bl = result = actor instanceof OutputProducer && this.m_Compatibility.isCompatible(((OutputProducer)((Object)actor)).generates(), this.m_Generates);
            }
            if (result && this.m_Restrictions != null) {
                Class restriction;
                classArray = this.m_Restrictions;
                int n = classArray.length;
                for (int i = 0; i < n && (result = (restriction = classArray[i]).isInterface() ? ClassLocator.hasInterface(restriction, cls) : ClassLocator.isSubclass(restriction, cls)); ++i) {
                }
            }
            return result;
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("enabled=" + this.isEnabled());
        result.append(", ");
        result.append("accepts=" + (this.getAccepts() == null ? "null" : Utils.arrayToString(this.getAccepts(), true)));
        result.append(", ");
        result.append("generates=" + (this.getGenerates() == null ? "null" : Utils.arrayToString(this.getGenerates(), true)));
        result.append(", ");
        result.append("standalones=" + this.m_StandalonesAllowed);
        return result.toString();
    }
}

