/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.print;

import adams.core.management.LocaleHelper;
import adams.gui.print.BufferedImageBasedWriter;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;

public class JPEGWriter
extends BufferedImageBasedWriter {
    private static final long serialVersionUID = -6501256101213777499L;
    protected double m_Quality;

    @Override
    public String globalInfo() {
        return "Outputs JPEG images.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("quality", "quality", 1.0);
    }

    @Override
    public String getDescription() {
        return "JPEG-Image";
    }

    @Override
    public String[] getExtensions() {
        return new String[]{".jpg", ".jpeg"};
    }

    public void setQuality(double value) {
        this.m_Quality = value;
    }

    public double getQuality() {
        return this.m_Quality;
    }

    public String qualityTipText() {
        return "The JPEG quality (0.0 - 1.0).";
    }

    @Override
    public void generateOutput() throws Exception {
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(this.getExtensions()[0].replace(".", ""));
        if (!iter.hasNext()) {
            throw new Exception("No writer available for " + this.getDescription() + "!");
        }
        writer = iter.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(this.getFile().getAbsoluteFile());
        writer.setOutput(ios);
        JPEGImageWriteParam param = new JPEGImageWriteParam(LocaleHelper.getSingleton().getDefault());
        param.setCompressionMode(2);
        param.setCompressionQuality((float)this.getQuality());
        writer.write(null, new IIOImage(this.createBufferedImage(), null, null), param);
        ios.flush();
        writer.dispose();
        ios.close();
    }
}

