/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.sendto;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.gui.sendto.AbstractSendToAction;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;

@MixedCopyright(copyright="1995, 2008, Oracle and/or its affiliates", license=License.BSD3, url="http://download.oracle.com/javase/tutorial/2d/printing/examples/PrintUIWindow.java")
public class Printer
extends AbstractSendToAction {
    private static final long serialVersionUID = -6357616730945070639L;

    @Override
    public String getAction() {
        return "Printer";
    }

    @Override
    public String getIconName() {
        return "print.gif";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Component.class, JComponent.class, JTextComponent.class, JTable.class};
    }

    @Override
    public String send(Object o) {
        String result = null;
        if (o instanceof JTextComponent) {
            JTextComponent text = (JTextComponent)o;
            try {
                text.print(null, null, true, null, null, true);
            }
            catch (Exception e) {
                String msg = "Failed to print:";
                this.getLogger().log(Level.SEVERE, msg, e);
                result = msg + "\n" + e;
            }
        } else if (o instanceof JTable) {
            try {
                if (!((JTable)o).print()) {
                    result = "Printing canceled by user!";
                }
            }
            catch (Exception e) {
                String msg = "Failed to print:";
                this.getLogger().log(Level.SEVERE, msg, e);
                result = msg + "\n" + e;
            }
        } else if (o instanceof Component || o instanceof JComponent) {
            final Component comp = (Component)o;
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintable(new Printable(){

                @Override
                public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
                    if (pageIndex > 0) {
                        return 1;
                    }
                    ((Graphics2D)graphics).translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                    comp.printAll(graphics);
                    return 0;
                }
            });
            boolean ok = job.printDialog();
            if (ok) {
                try {
                    job.print();
                }
                catch (PrinterException e) {
                    String msg = "Failed to print:";
                    this.getLogger().log(Level.SEVERE, msg, e);
                    result = msg + "\n" + e;
                }
            } else {
                result = "Failed to display printer dialog!";
            }
        } else {
            result = "Cannot print object: " + o.getClass();
        }
        return result;
    }
}

