/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractReportReader;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.report.ReportFactory;
import java.io.File;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class AbstractReportHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -3800895640927273805L;

    @Override
    public String globalInfo() {
        return "Displays the following report types: " + Utils.arrayToString(this.getExtensions());
    }

    protected abstract AbstractReportReader getReader(File var1);

    @Override
    protected PreviewPanel createPreview(File file) {
        AbstractReportReader reader = this.getReader(file);
        reader.setInput(new PlaceholderFile(file));
        List reports = reader.read();
        final ReportFactory.Panel panel = ReportFactory.getPanelForReports(reports);
        if (reports.size() > 0) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    panel.getReportContainerList().getTable().getSelectionModel().setSelectionInterval(0, 0);
                }
            };
            SwingUtilities.invokeLater(run);
        }
        reader.destroy();
        return new PreviewPanel(panel);
    }
}

