/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.flow.sink.sequenceplotter.SequencePlotContainer;
import adams.flow.sink.sequenceplotter.SequencePlotContainerManager;
import adams.flow.sink.sequenceplotter.SequencePlotSequence;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.gui.core.BasePanel;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.BarPaintlet;
import java.awt.Dimension;
import java.awt.GridLayout;

public abstract class AbstractHistogramPanel<T>
extends BasePanel {
    private static final long serialVersionUID = -8621818594275641231L;
    protected GridLayout m_Layout;
    protected T m_Data;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_Layout = new GridLayout(0, 1);
        this.setLayout(this.m_Layout);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.update();
    }

    protected SequencePlotterPanel newPanel(String name) {
        SequencePlotterPanel result = new SequencePlotterPanel(name);
        result.setSidePanelVisible(false);
        BarPaintlet paintlet = new BarPaintlet();
        paintlet.setWidth(3);
        result.setPaintlet(paintlet);
        FancyTickGenerator tick = new FancyTickGenerator();
        tick.setNumTicks(10);
        result.getPlot().getAxis(Axis.LEFT).setTickGenerator(tick);
        result.getPlot().getAxis(Axis.LEFT).setNthValueToShow(3);
        result.getPlot().getAxis(Axis.LEFT).setNumberFormat("0");
        result.getPlot().getAxis(Axis.LEFT).setAxisName("");
        tick = new FancyTickGenerator();
        tick.setNumTicks(20);
        result.getPlot().getAxis(Axis.BOTTOM).setTickGenerator(tick);
        result.getPlot().getAxis(Axis.BOTTOM).setNthValueToShow(5);
        result.getPlot().getAxis(Axis.BOTTOM).setNumberFormat("0");
        result.getPlot().getAxis(Axis.BOTTOM).setAxisName("");
        result.getPlot().getAxis(Axis.BOTTOM).setTopMargin(0.01);
        result.getPlot().getAxis(Axis.BOTTOM).setBottomMargin(0.01);
        result.setPreferredSize(new Dimension(600, 200));
        return result;
    }

    protected abstract SequencePlotSequence[] createSequences();

    protected void update() {
        this.removeAll();
        if (this.m_Data == null) {
            this.m_Layout.setRows(0);
            return;
        }
        SequencePlotSequence[] seq = this.createSequences();
        this.m_Layout.setRows(seq.length);
        for (int i = 0; i < seq.length; ++i) {
            SequencePlotterPanel panel = this.newPanel(seq[i].getID());
            SequencePlotContainerManager manager = (SequencePlotContainerManager)panel.getContainerManager();
            SequencePlotContainer cont = manager.newContainer(seq[i]);
            manager.add(cont);
            this.add(panel);
        }
    }

    public void setData(T value) {
        this.m_Data = value;
        this.update();
    }

    public T getData() {
        return this.m_Data;
    }
}

