/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AbstractPaintlet;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import java.awt.Graphics;

public class MultiPaintlet
extends AbstractPaintlet {
    private static final long serialVersionUID = 159999248427405834L;
    protected Paintlet[] m_SubPaintlets;

    @Override
    public String globalInfo() {
        return "Combines multiple paintlets.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("paintlet", "subPaintlets", this.getDefaultSubPaintlets());
    }

    protected Paintlet[] getDefaultSubPaintlets() {
        return new Paintlet[0];
    }

    public void setSubPaintlets(Paintlet[] value) {
        this.m_SubPaintlets = value;
        this.setPanel(this.getPanel());
        this.memberChanged();
    }

    public Paintlet[] getSubPaintlets() {
        return this.m_SubPaintlets;
    }

    public String subPaintletsTipText() {
        return "The paintlets to combine.";
    }

    @Override
    public void setPanel(PaintablePanel value) {
        super.setPanel(value);
        for (Paintlet paintlet : this.m_SubPaintlets) {
            paintlet.setPanel(value);
        }
    }

    @Override
    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.MULTIPLE;
    }

    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        for (Paintlet paintlet : this.m_SubPaintlets) {
            if (!paintlet.canPaint(moment)) continue;
            paintlet.performPaint(g, moment);
        }
    }
}

