/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.plugins.AbstractImageViewerPlugin;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.logging.Level;

public abstract class AbstractCurrentImageFilter
extends AbstractImageViewerPlugin {
    private static final long serialVersionUID = 869121794905442017L;
    protected String m_FilterError;

    @Override
    public boolean canExecute(ImagePanel panel) {
        return panel != null && panel.getCurrentImage() != null;
    }

    protected abstract BufferedImage filter(BufferedImage var1);

    @Override
    protected String doExecute() {
        String result = null;
        ((ImagePanel)this.m_CurrentPanel).addUndoPoint("Saving undo data...", "Filtering image: " + this.getCaption());
        BufferedImage input = ((ImagePanel)this.m_CurrentPanel).getCurrentImage();
        double scale = ((ImagePanel)this.m_CurrentPanel).getScale();
        this.m_FilterError = null;
        try {
            BufferedImage output = this.filter(input);
            if (this.m_CanceledByUser) {
                return result;
            }
            if (output == null) {
                result = "Failed to filter image: ";
                result = this.m_FilterError == null ? result + "unknown reason" : result + this.m_FilterError;
            } else {
                File file = ((ImagePanel)this.m_CurrentPanel).getCurrentFile();
                ((ImagePanel)this.m_CurrentPanel).setCurrentImage(output);
                ((ImagePanel)this.m_CurrentPanel).setCurrentFile(file);
                ((ImagePanel)this.m_CurrentPanel).setModified(true);
                ((ImagePanel)this.m_CurrentPanel).setScale(scale);
            }
        }
        catch (Exception e) {
            this.m_FilterError = e.toString();
            result = "Failed to filter image: ";
            this.getLogger().log(Level.SEVERE, result, e);
            result = result + this.m_FilterError;
        }
        return result;
    }
}

