/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.report;

import adams.data.report.Report;
import adams.db.AbstractDatabaseConnection;
import adams.gui.event.DataChangeEvent;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.DatabaseContainerManager;
import adams.gui.visualization.container.NamedContainerManager;
import adams.gui.visualization.report.ReportContainer;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;

public class ReportContainerManager
extends AbstractContainerManager<ReportContainer>
implements NamedContainerManager,
DatabaseContainerManager<ReportContainer> {
    private static final long serialVersionUID = -6144975286254812052L;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    public ReportContainerManager(AbstractDatabaseConnection dbcon) {
        this.m_DatabaseConnection = dbcon;
    }

    @Override
    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }

    @Override
    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        this.m_DatabaseConnection = value;
    }

    public int[] getVisibleIndices() {
        TIntArrayList result = new TIntArrayList();
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            result.add(i);
        }
        return result.toArray();
    }

    public List<ReportContainer> getAllVisible() {
        ArrayList<ReportContainer> result = new ArrayList<ReportContainer>();
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            ReportContainer cont = (ReportContainer)((ReportContainer)this.get(i)).copy();
            cont.setManager(null);
            result.add(cont);
        }
        return result;
    }

    public boolean isVisible(int index) {
        return ((ReportContainer)this.get(index)).isVisible();
    }

    public void setVisible(int index, boolean visible) {
        ((ReportContainer)this.get(index)).setVisible(visible);
        this.notifyDataChangeListeners(new DataChangeEvent((AbstractContainerManager)this, DataChangeEvent.Type.VISIBILITY, index));
    }

    public ReportContainer getVisible(int index) {
        ReportContainer result = null;
        int count = -1;
        for (int i = 0; i < this.count(); ++i) {
            if (this.isVisible(i)) {
                ++count;
            }
            if (count != index) continue;
            result = (ReportContainer)this.get(i);
            break;
        }
        return result;
    }

    public int countVisible() {
        int result = 0;
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int indexOf(String id) {
        int result = -1;
        for (int i = 0; i < this.count(); ++i) {
            if (!((ReportContainer)this.get(i)).getID().equals(id)) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public ReportContainer newContainer(Comparable o) {
        return new ReportContainer(this, (Report)o);
    }
}

