/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.core.base.BaseString;
import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.LinePaintlet;
import adams.gui.visualization.sequence.PaintletWithCustomDataSupport;
import adams.parser.MathematicalExpression;
import adams.parser.MathematicalExpressionText;
import java.awt.Color;
import java.awt.Graphics;
import java.util.logging.Level;

public class MathExpressionOverlayPaintlet
extends AbstractXYSequencePaintlet {
    private static final long serialVersionUID = 6292059403058224856L;
    protected MathematicalExpressionText m_Expression;
    protected int m_NumPoints;
    protected PaintletWithCustomDataSupport m_Paintlet;
    protected Color m_Color;

    @Override
    public String globalInfo() {
        return "Calculates data points using the provided mathematical expression and paints them using the specified paintlet.\nIf the expression generates a NaN ('not a number') the x/y pair gets ignored.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", new MathematicalExpressionText("X"));
        this.m_OptionManager.add("num-points", "numPoints", 100, 1, null);
        this.m_OptionManager.add("paintlet", "paintlet", new LinePaintlet());
        this.m_OptionManager.add("color", "color", Color.BLACK);
    }

    public void setExpression(MathematicalExpressionText value) {
        this.m_Expression = value;
        this.reset();
    }

    public MathematicalExpressionText getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The mathematical expression to use for generating the Y values; use 'X' as the current data point on the X axis in your expression.";
    }

    public void setNumPoints(int value) {
        this.m_NumPoints = value;
        this.reset();
    }

    public int getNumPoints() {
        return this.m_NumPoints;
    }

    public String numPointsTipText() {
        return "The number of data points to generate for the overlay.";
    }

    public void setPaintlet(PaintletWithCustomDataSupport value) {
        this.m_Paintlet = value;
        if (this.m_Paintlet != null) {
            this.m_Paintlet.setPanel(null);
        }
        this.reset();
    }

    public PaintletWithCustomDataSupport getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "The paintlet to use for painting the generated data points.";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.memberChanged();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color for the line.";
    }

    @Override
    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.GRID;
    }

    @Override
    public AbstractXYSequencePointHitDetector newHitDetector() {
        return null;
    }

    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        AxisPanel xAxis = this.getPlot().getAxis(Axis.BOTTOM);
        double xMin = xAxis.getActualMinimum();
        double xMax = xAxis.getActualMaximum();
        XYSequence data = new XYSequence();
        MathematicalExpression expr = new MathematicalExpression();
        expr.setExpression(this.m_Expression.getValue());
        for (int i = 0; i < this.m_NumPoints; ++i) {
            double x = xMin + (xMax - xMin) / (double)(this.m_NumPoints - 1) * (double)i;
            expr.setSymbols(new BaseString[]{new BaseString("X=" + x)});
            try {
                double y = (Double)expr.evaluate();
                if (!Double.isNaN(y)) {
                    data.add(new XYSequencePoint(x, y));
                }
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().info("f(" + x + ") = " + y + (Double.isNaN(y) ? " (skipped)" : ""));
                continue;
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to evaluate '" + this.m_Expression + "' using x=" + x, e);
            }
        }
        this.m_Paintlet.setPanel(this.getPanel(), false);
        this.m_Paintlet.drawCustomData(g, moment, data, this.m_Color);
        this.m_Paintlet.setPanel(null);
    }
}

