/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.wizard;

import adams.core.Properties;
import adams.core.Utils;
import adams.gui.core.BaseList;
import adams.gui.core.BaseScrollPane;
import adams.gui.wizard.AbstractWizardPage;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

public class ListPage
extends AbstractWizardPage {
    private static final long serialVersionUID = -7633802524155866313L;
    public static final String KEY_LIST = "list";
    public static final String KEY_SELECTED = "selected";
    protected BaseList m_List;
    protected boolean m_AddFullList;

    public ListPage() {
    }

    public ListPage(String pageName) {
        this();
        this.setPageName(pageName);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_AddFullList = false;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_List = new BaseList((ListModel)new DefaultListModel());
        this.add((Component)new BaseScrollPane(this.m_List), "Center");
    }

    public void setSelectionMode(int value) {
        this.m_List.setSelectionMode(value);
    }

    public int getSelectionMode() {
        return this.m_List.getSelectionMode();
    }

    public BaseList getList() {
        return this.m_List;
    }

    public void setValues(String[] value) {
        this.setValues(Arrays.asList(value));
    }

    public void setValues(List<String> value) {
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String v : value) {
            model.addElement(v);
        }
        this.m_List.setModel(model);
    }

    public void setSelectedValues(String[] value) {
        this.setSelectedValues(Arrays.asList(value));
    }

    public void setSelectedValues(List<String> value) {
        TIntArrayList selected = new TIntArrayList();
        DefaultListModel model = (DefaultListModel)this.m_List.getModel();
        for (String v : value) {
            if (!model.contains(v)) continue;
            selected.add(model.indexOf(v));
        }
        this.m_List.setSelectedIndices(selected.toArray());
    }

    public void setAddFullList(boolean value) {
        this.m_AddFullList = value;
    }

    public boolean getAddFullList() {
        return this.m_AddFullList;
    }

    @Override
    public Properties getProperties() {
        Properties result = new Properties();
        if (this.m_AddFullList) {
            result.setProperty(KEY_LIST, Utils.flatten(((DefaultListModel)this.m_List.getModel()).toArray(), ","));
        }
        result.setProperty(KEY_SELECTED, Utils.flatten(this.m_List.getSelectedValuesList(), ","));
        return result;
    }
}

